package com.qiho.center.api.dto.data;

import com.qiho.center.api.dto.BaseDto;

import java.math.BigDecimal;

/**
 * 商家日消耗订单统计Dto
 * @author chensong
 * @create 2018-08-13
 */
public class MerchantDaliyOrderDto extends BaseDto {

    private static final long serialVersionUID = 2418786064670782570L;

    /** 商家id */
    private Long merchantId;

    /** 订单创建日期 yyyy/MM/dd 形式 */
    private String orderTimeStr;

    /** 商品id */
    private Long itemId;

    /** 商品简称 */
    private String itemShortName;

    /** 广告消耗 */
    private Integer adConsume;

    /** 订单数 */
    private Integer orderCt;

    /** 出单数 */
    private Integer orderSdCt;

    /** 出单率 */
    private BigDecimal orderSdRate;

    /** 签收订单数 */
    private Integer orderSngCt;

    /** 订单签收率 */
    private BigDecimal orderSngRate;

    /** 订单成本 */
    private Integer orderCost;


    public String getOrderTimeStr() {
        return orderTimeStr;
    }

    public void setOrderTimeStr(String orderTimeStr) {
        this.orderTimeStr = orderTimeStr;
    }

    public Long getMerchantId() {
        return merchantId;
    }

    public void setMerchantId(Long merchantId) {
        this.merchantId = merchantId;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public String getItemShortName() {
        return itemShortName;
    }

    public void setItemShortName(String itemShortName) {
        this.itemShortName = itemShortName;
    }

    public Integer getAdConsume() {
        return adConsume;
    }

    public void setAdConsume(Integer adConsume) {
        this.adConsume = adConsume;
    }

    public Integer getOrderCt() {
        return orderCt;
    }

    public void setOrderCt(Integer orderCt) {
        this.orderCt = orderCt;
    }

    public Integer getOrderSdCt() {
        return orderSdCt;
    }

    public void setOrderSdCt(Integer orderSdCt) {
        this.orderSdCt = orderSdCt;
    }

    public BigDecimal getOrderSdRate() {
        return orderSdRate;
    }

    public void setOrderSdRate(BigDecimal orderSdRate) {
        this.orderSdRate = orderSdRate;
    }

    public Integer getOrderSngCt() {
        return orderSngCt;
    }

    public void setOrderSngCt(Integer orderSngCt) {
        this.orderSngCt = orderSngCt;
    }

    public BigDecimal getOrderSngRate() {
        return orderSngRate;
    }

    public void setOrderSngRate(BigDecimal orderSngRate) {
        this.orderSngRate = orderSngRate;
    }

    public Integer getOrderCost() {
        return orderCost;
    }

    public void setOrderCost(Integer orderCost) {
        this.orderCost = orderCost;
    }
}
