package com.qiho.center.api.dto.logistics;

import com.qiho.center.api.dto.BaseDto;
import com.qiho.center.api.enums.YTOErrorCodeReturnEnum;

/**
 * ClassName: QueryLogisticsOrderDto <br/>
 * Function: 订单发货物流信息更新返回DTO. <br/>
 * date: 2017年6月3日 下午2:55:11 <br/>
 *
 * @author chencheng
 * @version
 */
public class YTOLogisticsMsgReturnDto extends BaseDto {

    private static final long serialVersionUID = -5178890603185402509L;

    /** 物流公司ID（YTO） */
    private String            logisticProviderID;

    /** 物流号 */
    private String            txLogisticID;

    /** true/false */
    private Boolean           success;

    /** 原因 */
    private String            reason;

    /**
     * logisticProviderID.
     *
     * @return the logisticProviderID
     */
    public String getLogisticProviderID() {
        return logisticProviderID;
    }

    /**
     * logisticProviderID.
     *
     * @param logisticProviderID the logisticProviderID to set
     */
    public void setLogisticProviderID(String logisticProviderID) {
        this.logisticProviderID = logisticProviderID;
    }

    /**
     * txLogisticID.
     *
     * @return the txLogisticID
     */
    public String getTxLogisticID() {
        return txLogisticID;
    }

    /**
     * txLogisticID.
     *
     * @param txLogisticID the txLogisticID to set
     */
    public void setTxLogisticID(String txLogisticID) {
        this.txLogisticID = txLogisticID;
    }

    /**
     * success.
     *
     * @return the success
     */
    public Boolean getSuccess() {
        return success;
    }

    /**
     * success.
     *
     * @param success the success to set
     */
    public void setSuccess(Boolean success) {
        this.success = success;
    }

    /**
     * reason.
     *
     * @return the reason
     */
    public String getReason() {
        return reason;
    }

    /**
     * reason.
     *
     * @param reason the reason to set
     */
    public void setReason(String reason) {
        this.reason = reason;
    }

    public YTOLogisticsMsgReturnDto() {
        super();
    }

    public YTOLogisticsMsgReturnDto(String logisticProviderID, String txLogisticID, Boolean success, String reason) {
        super();
        this.logisticProviderID = logisticProviderID;
        this.txLogisticID = txLogisticID;
        this.success = success;
        this.reason = reason;
    }

    public void setSuccessAndReason(YTOErrorCodeReturnEnum logisticsError) {
        this.success = logisticsError.getCode();
        this.reason = logisticsError.getDesc();
    }

}
