package com.qiho.center.api.enums;

import org.apache.commons.lang3.StringUtils;

/** 参数内时间操作类型枚举
 * @author jiafeng.geng
 * @create 2018-04-02 09:35:41
 **/
public enum GetParamTimeEnum {

    START_TIME("START_TIME", "开始时间", 0),

    END_TIME("END_TIME", "结束时间", 1),
    ;

    /** 代码 */
    private String code;

    /** 描述 */
    private String desc;

    /** 数值 */
    private Integer num;

    private GetParamTimeEnum(String code, String desc, Integer num){
        this.code = code;
        this.desc = desc;
        this.num = num;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public Integer getNum() {
        return num;
    }

    public static GetParamTimeEnum getByCode(String code){
        for (GetParamTimeEnum value : GetParamTimeEnum.values() ) {
            if (StringUtils.equals(value.getCode(), code)) {
                return value;
            }
        }
        return null;
    }

    public static GetParamTimeEnum getByNum(int num){
        for (GetParamTimeEnum value : GetParamTimeEnum.values()) {
            if (value.getNum().intValue() == num) {
                return value;
            }
        }
        return null;
    }

    public static GetParamTimeEnum getByNum(Integer num){
        return getByNum(num.intValue());
    }


}
