package com.qiho.center.api.enums.area;

import org.apache.commons.lang3.StringUtils;

/**
 * @author chensong
 * @create 2018-01-24 10:35
 **/
public enum AreaTypeEnum {

    PROVINCE("PROVINCE", "省份", 1),

    CITY("CITY", "城市", 2),

    COUNTY("COUNTY", "区县", 3),

    TOWN("TOWN", "乡镇", 4);

    /** 代码 */
    private String code;

    /** 描述 */
    private String desc;

    /** 数字类型 */
    private Integer num;

    private AreaTypeEnum(String code, String desc, Integer num){
        this.code = code;
        this.desc = desc;
        this.num = num;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public Integer getNum() {
        return num;
    }

    public static AreaTypeEnum getByCode(String code){
        for (AreaTypeEnum value : AreaTypeEnum.values()) {
            if (StringUtils.equals(code, value.getCode())) {
                return value;
            }
        }
        return null;
    }

    public static AreaTypeEnum getByNum(int num){
        for (AreaTypeEnum value : AreaTypeEnum.values()) {
            if (num == value.getNum().intValue()) {
                return value;
            }
        }
        return null;
    }

    public static AreaTypeEnum getByNum(Integer num){
         return getByNum(num.intValue());
    }
}
