package com.qiho.center.api.enums.page;

/**
 * @author jiafeng.geng
 * @date 2018-07-25.
 */
public enum CollItemStatusEnum {
    /**
     * 集合页商品启用
     */
    STATUS_ON(1, "启用"),

    /**
     * 集合页商品禁用
     */
    STATUS_OFF(0, "禁用");

    /**
     * 代码
     */
    private Integer value;

    /**
     * 描述
     */
    private String desc;

    private CollItemStatusEnum(Integer value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    /**
     * @param value
     * @return DatabaseSchema
     */
    public static CollItemStatusEnum getByValue(Integer value) {
        for (CollItemStatusEnum enumVal : CollItemStatusEnum.values()) {
            if (value == enumVal.getValue()) {
                return enumVal;
            }
        }
        return null;
    }

    /**
     * @return value
     */
    public Integer getValue() {
        return value;
    }

    /**
     * @return desc
     */
    public String getDesc() {
        return desc;
    }
}

