package com.qiho.center.api.remoteservice.security;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.security.SecurityFundApplyDetailDto;
import com.qiho.center.api.dto.security.SecurityFundApplyDto;
import com.qiho.center.api.dto.security.SecurityMerchantInfoDto;
import com.qiho.center.api.dto.security.param.SecurityFundApplyParam;
import com.qiho.center.api.dto.security.param.SecurityFundApplyQueryParam;
import com.qiho.center.api.dto.security.param.SecurityFundApproveParam;

/**
 * @author huangruodan
 * @version 创建时间：2020/8/21 2:15 下午
 */
@AdvancedFeignClient
public interface RemoteSecurityFundService {

    /**
     * 申请列表
     * @param param 参数
     * @return 申请列表
     */
    PagenationDto<SecurityFundApplyDto> queryPage(SecurityFundApplyQueryParam param) throws BizException;

    /**
     * 商户保证金信息
     * @param merchantId 商户id
     * @return 商户保证金信息
     */
    SecurityMerchantInfoDto getMerchantDetail(Long merchantId) throws BizException;

    /**
     * 获取申请详情
     * @param applyId 申请id
     * @return 申请详情
     */
    SecurityFundApplyDetailDto getApplyDetail(Long applyId) throws BizException;

    /**
     * 申请保证金
     * @param applyParam 申请信息
     * @return 申请详情
     */
    Long applySecurityFund(SecurityFundApplyParam applyParam) throws BizException;

    /**
     * 审批保证金
     * @param approveParam 审批参数
     * @return 申请详情
     */
    Boolean approveSecurityFund(SecurityFundApproveParam approveParam) throws BizException;
}
