package com.qiho.center.api.remoteservice.order;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.order.ConfirmOrderListDto;
import com.qiho.center.api.dto.order.param.ConfirmOrderQueryParam;
import com.qiho.center.api.dto.order.param.ConfirmOrderSignParam;

/**
 * @author huangruodan
 * @version 创建时间：2020/9/1 5:50 下午
 */
@AdvancedFeignClient
public interface RemoteConfirmOrderService {

    /**
     * 人工订单列表
     * @param param 查询参数
     * @return 列表
     */
    PagenationDto<ConfirmOrderListDto> confirmOrderList(ConfirmOrderQueryParam param) throws BizException;

    /**
     * 签收
     * @param param 签收类型、订单id
     * @return 是否成功
     */
    Boolean signExpress(ConfirmOrderSignParam param) throws BizException;
}
