package com.qiho.center.api.dto.discount;

import com.qiho.center.api.dto.BaseDto;
import com.qiho.center.api.enums.discount.DiscountTypeEnum;
import com.qiho.center.api.enums.discount.DiscountUseTermTypeEnum;

import java.util.Date;

/**
 * 订单优惠记录
 *
 * @author chensong
 * @create 2018-09-04
 */
public class OrderDiscountDto extends BaseDto {

    private static final long serialVersionUID = -7949155637531494007L;

    /** id */
    private Long id;

    /** 订单id */
    private String orderId;

    /** 优惠类型 */
    private DiscountTypeEnum discountType;

    /** 优惠数值
     */
    private Integer discountValue;

    /** 使用条件的类型 */
    private DiscountUseTermTypeEnum useType;

    /** 使用条件的阈值 */
    private Integer useThreshold;

    /** 备注 */
    private String remark;

    /** 创建时间 */
    private Date gmtCreate;

    /** 修改时间 */
    private Date gmtModified;

    public Integer getDiscountValue() {
        return discountValue;
    }

    public void setDiscountValue(Integer discountValue) {
        this.discountValue = discountValue;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getOrderId() {
        return orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public DiscountTypeEnum getDiscountType() {
        return discountType;
    }

    public void setDiscountType(DiscountTypeEnum discountType) {
        this.discountType = discountType;
    }

    public DiscountUseTermTypeEnum getUseType() {
        return useType;
    }

    public void setUseType(DiscountUseTermTypeEnum useType) {
        this.useType = useType;
    }

    public Integer getUseThreshold() {
        return useThreshold;
    }

    public void setUseThreshold(Integer useThreshold) {
        this.useThreshold = useThreshold;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }
}
