package com.qiho.center.api.dto.menu;

import java.util.List;
import java.util.Objects;

/**
 * AccountMenuDto
 *
 * @author zhangshun
 * @version V1.0
 * @since 2017-12-07 18:42
 */
public class AccountMenuDto extends MenuDto {

    private Long accountId;

    private Boolean selected = false;

    /**
     * 子菜单列表
     */
    private List<AccountMenuDto> subMenu;

    public Long getAccountId() {
        return accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public Boolean getSelected() {
        return selected;
    }

    public void setSelected(Boolean selected) {
        this.selected = selected;
    }

    public List<AccountMenuDto> getSubMenu() {
        return subMenu;
    }

    public void setSubMenu(List<AccountMenuDto> subMenu) {
        this.subMenu = subMenu;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o)
            return true;
        if (o == null || getClass() != o.getClass())
            return false;
        if (!super.equals(o))
            return false;
        AccountMenuDto that = (AccountMenuDto) o;
        return Objects.equals(accountId, that.accountId) && Objects.equals(selected, that.selected) && Objects
            .equals(subMenu, that.subMenu);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), accountId, selected, subMenu);
    }

    @Override
    public String toString() {
        return "AccountMenuDto{" + "accountId=" + accountId + ", selected=" + selected + ", subMenu=" + subMenu + '}';
    }
}
