package com.qiho.center.api.enums;

import java.util.Arrays;

/**
 * 策略适用类型
 *
 * @author peanut.huang
 * @date 2018/3/15.
 */
public enum  StrategyUseType {

    /**
     *
     */
    ALL(0,"全部"),

    PART(1,"部分");

    /**
     * 值
     */
    private int value;

    /**
     *  描述
     */
    private String desc;

    StrategyUseType(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    /**
     * 根据值取得枚举
     *
     * @param value  枚举值
     * @return       枚举
     */
    public static StrategyUseType findByValue(int value){
        return Arrays.stream(StrategyUseType.values()).filter(e -> e.getValue() == value).findFirst().orElse(null);
    }



    public int getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }
}
