package com.qiho.center.api.enums.account;


/**
 * 用户类型
 * Created by sunchangji on 2017/12/7.
 */
public enum BaiqiAccountTypeEnum {
    MAIN_ACCOUNT(0, "商家", "商家主账户"),
    SUB_ACCOUNT(1, "商家", "商家子账户"),
    AGENT_ACCOUNT(2, "代理商", "代理商账户");

    BaiqiAccountTypeEnum(int code, String typeName, String desc) {
        this.code = code;
        this.typeName = typeName;
        this.desc = desc;
    }

    private int code;
    private String typeName;
    private String desc;

    public int getCode() {
        return code;
    }

    public String getTypeName() {
        return typeName;
    }

    public String getDesc() {
        return desc;
    }

    public static BaiqiAccountTypeEnum getByCode(Integer code){
        return getByCode(code.intValue());
    }

    public static BaiqiAccountTypeEnum getByCode(int code){
        for (BaiqiAccountTypeEnum value : BaiqiAccountTypeEnum.values()) {
            if (value.getCode() == code) {
                return value;
            }
        }
        return null;
    }


}
