package com.qiho.center.api.enums.component;

import java.util.stream.Stream;

/**
 * 组件化皮肤的适用类型   商品详情页、集合页..
 *
 * @author chensong
 * @create 2018-09-19
 */
public enum ComponentUsageTypeEnum {

    ITEM_DEATIL(1, "ITEM_DETAIL", "商品详情页"),

    COLLECTION_PAGE(2, "COLLECTION_PAGE", "集合页"),

    ;

    /** 数值 */
    private int num;

    /** 代码 */
    private String code;

    /** 描述 */
    private String desc;

    private ComponentUsageTypeEnum(int num, String code, String desc) {
        this.num = num;
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public int getNum() {
        return num;
    }

    public static ComponentUsageTypeEnum getByNum(int num){
        return Stream.of(ComponentUsageTypeEnum.values()).filter(e -> e.getNum() == num).findFirst().orElse(null);
    }







}
