package com.qiho.center.api.enums.finance;

/**
 * PartnerResultStateEnum
 *
 * @author zhangshun
 * @version V1.0
 * @since 2017-12-27 20:32
 */
public enum PartnerResultStateEnum {

    FAILED(0, "失败"),

    SUCCEED(1, "成功"),

    EXCEPTION(2, "超时或异常");

    /**
     * 代码
     */
    private Integer code;

    /**
     * 数值
     */
    private String name;

    PartnerResultStateEnum(Integer code, String name) {
        this.code = code;
        this.name = name;
    }

    public Integer getCode() {
        return code;
    }

    public String getName() {
        return name;
    }

    @Override
    public String toString() {
        return "PartnerResultStateEnum{" + "code=" + code + ", name='" + name + '\'' + "} " + super.toString();
    }
}
