package com.qiho.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.bklist.BaiqiBlackListDto;
import com.qiho.center.api.dto.domain.DomainDto;
import com.qiho.center.api.params.blacklist.BaiqiBlackListQueryParam;
import com.qiho.center.api.params.domain.DomainQueryParam;

import java.util.List;

@AdvancedFeignClient
public interface RemoteDomainService {

    /**
     * 保存域名
     * @param domainDto
     * @return
     */
    boolean save(DomainDto domainDto);

    /**
     * 根据id删除一条记录（逻辑删除）
     * @param id
     * @return
     */
    int delete(long id);

    /**
     * 根据状态查询有效域名
     * @param param
     * @return
     */
    PagenationDto<DomainDto> queryPage(DomainQueryParam param);

    /**
     * 域名是否有效
     * @param domainName
     * @return
     */
    boolean isValid(String domainName);


}
