package com.qiho.center.api.remoteservice.abtest;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.abtest.TestMetadataDto;
import com.qiho.center.api.params.TestMetadataQueryParam;

import java.util.List;

/**
 * Created by qianjue on 2017/10/10.
 */
@AdvancedFeignClient
public interface RemoteTestMetadataService {

	int  saveTestMetadata(TestMetadataDto dto) throws BizException;


	int  updateTestMetadata(TestMetadataDto dto) throws BizException;


	TestMetadataDto selectById(Long  id);


	List<TestMetadataDto> selectListByItemIdAndType(Long itemId,String metadataType);


	PagenationDto<TestMetadataDto> queryListByPage(TestMetadataQueryParam param) throws BizException;


	int  deleteTestMetadata(Long  id) throws BizException;

	/**
	 * 将测试信息同步至商品
	 * @param id
	 * @return
	 */
	boolean  syncToItemInfo(Long id,Long modifyId) throws BizException;
}
