/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.api.util;

import com.google.common.collect.Lists;
import com.qiho.center.api.dto.order.DeliveryRecordDto;
import com.qiho.center.api.params.OrderFileDeliveryParam;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class FileDeliveryUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileDeliveryUtil.class);

    private FileDeliveryUtil() {
    }

    public static synchronized int getExcelRowCount(String ossUrl, InputStream input) {
        Assert.notNull((Object)ossUrl, (String)("Excel\u6587\u4ef6\u540d\u4e3a\u7a7a\uff0cossUrl\uff1a" + ossUrl));
        Assert.notNull((Object)input, (String)("Excel\u6587\u4ef6\u6d41\u4e3a\u7a7a\uff0cossUrl\uff1a" + ossUrl));
        Sheet sheet = FileDeliveryUtil.getSheet(ossUrl, input);
        Assert.notNull((Object)sheet, (String)("Excel\u6587\u4ef6Sheet\u4e3a\u7a7a\uff0cossUrl\uff1a" + ossUrl));
        return sheet.getLastRowNum();
    }

    public static synchronized List<OrderFileDeliveryParam> getExcelContent(DeliveryRecordDto recordDto, InputStream input) {
        Assert.notNull((Object)recordDto, (String)"\u53c2\u6570\u4e3a\u7a7a");
        Assert.notNull((Object)recordDto.getFileUrl(), (String)"OSS\u6587\u4ef6\u540d\u4e3a\u7a7a");
        Assert.notNull((Object)recordDto.getId(), (String)("\u4efb\u52a1ID\uff0cossUrl\uff1a" + recordDto.getFileUrl()));
        Assert.notNull((Object)recordDto.getMerchantId(), (String)("\u5546\u5bb6ID\u4e3a\u7a7a\uff0cossUrl\uff1a" + recordDto.getFileUrl()));
        Assert.notNull((Object)recordDto.getLogisticsCode(), (String)("\u7269\u6d41\u7f16\u7801\u4e3a\u7a7a\uff0cossUrl\uff1a" + recordDto.getFileUrl()));
        Assert.notNull((Object)input, (String)("Excel\u6587\u4ef6\u6d41\u4e3a\u7a7a\uff0cossUrl\uff1a" + recordDto.getFileUrl()));
        Sheet sheet = FileDeliveryUtil.getSheet(recordDto.getFileUrl(), input);
        Assert.notNull((Object)sheet, (String)("Excel\u6587\u4ef6Sheet\u4e3a\u7a7a\uff0cossUrl\uff1a" + recordDto.getFileUrl()));
        int firstRowNum = sheet.getFirstRowNum();
        int lastRowNum = sheet.getLastRowNum();
        DeliveryHeaderNumber header = FileDeliveryUtil.getHeaderNumber(sheet.getRow(0));
        OrderFileDeliveryParam bean = null;
        ArrayList list = Lists.newArrayList();
        for (int rowNum = firstRowNum + 1; rowNum <= lastRowNum; ++rowNum) {
            try {
                bean = FileDeliveryUtil.setCellValue(rowNum + 1, header, sheet.getRow(rowNum));
                if (null == bean) continue;
                list.add(bean);
                continue;
            }
            catch (Exception e) {
                LOGGER.warn("\u89e3\u6790\u6587\u4ef6\u9519\u8bef\uff0cossUrl\uff1a" + recordDto.getFileUrl());
            }
        }
        return list;
    }

    private static OrderFileDeliveryParam setCellValue(int rowNum, DeliveryHeaderNumber header, Row row) {
        if (row == null) {
            return null;
        }
        OrderFileDeliveryParam bean = new OrderFileDeliveryParam();
        bean.setRowNumber(rowNum);
        Cell cellErp = null;
        Cell cellPost = null;
        if (null != header.getErp()) {
            cellErp = row.getCell(header.getErp().intValue());
        }
        if (null != header.getPost()) {
            cellPost = row.getCell(header.getPost().intValue());
        }
        if (null == cellErp) {
            bean.setErpId("");
        } else {
            bean.setErpId(FileDeliveryUtil.getCellValue(cellErp));
        }
        if (null == cellPost) {
            bean.setPostId("");
        } else {
            bean.setPostId(FileDeliveryUtil.getCellValue(cellPost));
        }
        if (StringUtils.isBlank((CharSequence)bean.getErpId()) && StringUtils.isBlank((CharSequence)bean.getPostId())) {
            return null;
        }
        return bean;
    }

    public static DeliveryHeaderNumber getHeaderNumber(Row row) {
        if (null == row) {
            return new DeliveryHeaderNumber(0, 1);
        }
        int first = row.getFirstCellNum();
        short last = row.getLastCellNum();
        DeliveryHeaderNumber cellNumber = new DeliveryHeaderNumber();
        Cell cell = null;
        for (int cellNum = first; cellNum < last; ++cellNum) {
            cell = row.getCell(cellNum);
            if (null == cell) continue;
            if ("\u5f85\u53d1\u8d27\u8ba2\u5355ID".equals(FileDeliveryUtil.getCellValue(cell)) || "\u5f85\u53d1\u8d27\u8ba2\u5355id".equals(FileDeliveryUtil.getCellValue(cell)) || "\u5f85\u53d1\u8d27\u8ba2\u5355\uff49\uff44".equals(FileDeliveryUtil.getCellValue(cell))) {
                cellNumber.setErp(cellNum);
            }
            if (!"\u7269\u6d41\u5355\u53f7".equals(FileDeliveryUtil.getCellValue(cell))) continue;
            cellNumber.setPost(cellNum);
        }
        return cellNumber;
    }

    public static Sheet getSheet(String ossUrl, InputStream input) {
        Sheet sheet = null;
        HSSFWorkbook workbook = null;
        try {
            if (ossUrl.endsWith("xls")) {
                workbook = new HSSFWorkbook(input);
            } else if (ossUrl.endsWith("xlsx")) {
                workbook = new XSSFWorkbook(input);
            }
            if (null == workbook) {
                return null;
            }
            sheet = workbook.getSheetAt(0);
            if (null == sheet) {
                return null;
            }
            return sheet;
        }
        catch (IOException e) {
            LOGGER.error("\u83b7\u53d6WorkBook\u9519\u8bef\uff0cUrl\uff1a{}", (Object)ossUrl);
            return null;
        }
    }

    public static String getCellValue(Cell cell) {
        if (null == cell) {
            return "";
        }
        try {
            if (CellType.NUMERIC == cell.getCellType()) {
                return String.valueOf(Double.valueOf(cell.getNumericCellValue()).longValue());
            }
            return StringUtils.trim((String)cell.getStringCellValue());
        }
        catch (Exception e) {
            return "";
        }
    }

    private static class DeliveryHeaderNumber {
        private Integer erp;
        private Integer post;

        public DeliveryHeaderNumber() {
        }

        public DeliveryHeaderNumber(Integer erp, Integer post) {
            this.erp = erp;
            this.post = post;
        }

        public Integer getErp() {
            return this.erp;
        }

        public void setErp(Integer erp) {
            this.erp = erp;
        }

        public Integer getPost() {
            return this.post;
        }

        public void setPost(Integer post) {
            this.post = post;
        }
    }
}

