package com.qiho.center.api.dto;

import com.qiho.center.api.dto.order.StrategyMerchantItemDto;
import com.qiho.center.api.enums.StrategyUseType;

import java.util.Date;
import java.util.List;

/**
 * Created by danke on 2017/6/21.
 */
public class OrderStrategyDto extends BaseDto{

    /**
     * 策略id
     */
    private Long id;
    /**
     * 策略名称
     */
    private String strategyName;

    /**
     * 策略类型,默认踢单辅助使用
     */
    private Integer strategyType;
    /**
     * 创建人
     */
    private String creator;
    /**
     * 创建时间
     */
    private Date gmtCreate;
    /**
     * 更新人
     */
    private String updator;
    /**
     * 更新时间
     */
    private Date gmtModified;
    /**
     * 规则类型json串
     */
    private String rulevalue;
    /**
     * 命中后处理链路的key
     * @return
     */
    private String handlerName;
    /**
     * 用户邮箱地址
     */
    private String email;
    /**
     * 策略状态
     */
    private Integer status;

    /**
     * 规则DTO
     * @return
     */
    private List<StrategyRuleDto> strategyRuleDtoList;

    /**
     * 策略适用类型 {@link StrategyUseType#value}
     */
    private Integer useType;

    /**
     * 策略适用的商家id与名称集
     */
    private List<StrategyMerchantItemDto> merchants;

    /**
     * 下单规则的提醒文案
     */
    private String alertText;

    /**
     * 创建人id
     */
    private Long creatorId;

    /**
     * 分权类型 {@link com.qiho.center.api.enums.strategy.StrategyAccessType}
     */
    private Integer accessType;


    public Integer getAccessType() {
        return accessType;
    }

    public void setAccessType(Integer accessType) {
        this.accessType = accessType;
    }

    public Long getCreatorId() {
        return creatorId;
    }

    public void setCreatorId(Long creatorId) {
        this.creatorId = creatorId;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getStrategyName() {
        return strategyName;
    }

    public void setStrategyName(String strategyName) {
        this.strategyName = strategyName;
    }

    public Integer getStrategyType() {
        return strategyType;
    }

    public void setStrategyType(Integer strategyType) {
        this.strategyType = strategyType;
    }

    public String getCreator() {
        return creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public String getUpdator() {
        return updator;
    }

    public void setUpdator(String updator) {
        this.updator = updator;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public String getRulevalue() {
        return rulevalue;
    }

    public void setRulevalue(String rulevalue) {
        this.rulevalue = rulevalue;
    }

    public String getHandlerName() {
        return handlerName;
    }

    public void setHandlerName(String handlerName) {
        this.handlerName = handlerName;
    }

    public List<StrategyRuleDto> getStrategyRuleDtoList() {
        return strategyRuleDtoList;
    }

    public void setStrategyRuleDtoList(List<StrategyRuleDto> strategyRuleDtoList) {
        this.strategyRuleDtoList = strategyRuleDtoList;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Integer getUseType() {
        return useType;
    }

    public void setUseType(Integer useType) {
        this.useType = useType;
    }

    public List<StrategyMerchantItemDto> getMerchants() {
        return merchants;
    }

    public void setMerchants(List<StrategyMerchantItemDto> merchants) {
        this.merchants = merchants;
    }

    public String getAlertText() {
        return alertText;
    }

    public void setAlertText(String alertText) {
        this.alertText = alertText;
    }
}
