package com.qiho.center.api.params;

import java.io.Serializable;

/**
 * Created by weny.cai on 2018/2/8.
 */
public class PageParam implements Serializable {

    private Integer offset; //后端查询的偏移量
    private Integer max;//查询的条数

    private Integer pageNum;//页码  页码必须大于0
    private Integer pageSize;//每页展示条数 每页展示条数必须大于0

    /**
     * 当前页最大或最小Id,
     */
    private Long offsetId;
    private boolean needCount = true;

    /**
     * 无参构造函数
     */
    public PageParam(){
        this.max = 20;
        this.offset = 0;
    }

    /**
     * 指定位移和加载个数
     * @param offset
     * @param max
     */
    public PageParam(int offset, int max){
        this.offset = offset;
        this.max = max;
    }

    public Integer getOffset() {
        return (this.pageNum - 1) * this.pageSize;
    }

    public Integer getMax() {
        return this.getPageSize();
    }

    public Long getOffsetId() {
        return offsetId;
    }

    public void setOffsetId(Long offsetId) {
        this.offsetId = offsetId;
    }

    public boolean isNeedCount() {
        return needCount;
    }

    public void setNeedCount(boolean needCount) {
        this.needCount = needCount;
    }

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

}
