package com.qiho.center.api.enums;

import org.apache.commons.lang.StringUtils;

/**
 * @author: wangjin
 * @create 2018-09-05 17:09
 **/
public enum WechatOrderStatusEnum {

    /** 订单待审核 */
    TO_APPROVE("TO_APPROVE", "待发货"),

    /** 订单待发货 */
    TO_SEND("TO_SEND", "待发货"),

    /** 订单已发货 */
    SEND_OUT("SEND_OUT", "已发货"),

    /** 订单交易成功 */
    SUCCESS("SUCCESS", "交易成功"),

    /** 订单交易关闭 */
    CLOSED("CLOSED", "交易关闭");

    /** 代码 */
    private String code;

    /** 描述 */
    private String desc;

    WechatOrderStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    /**
     * @param code
     * @return DatabaseSchema
     */
    public static WechatOrderStatusEnum getByCode(String code) {
        for (WechatOrderStatusEnum enumVal : WechatOrderStatusEnum.values()) {
            if (StringUtils.equals(code, enumVal.getCode())) {
                return enumVal;
            }
        }
        return null;
    }

    /**
     * @return code
     */
    public String getCode() {
        return code;
    }

    /**
     * @return desc
     */
    public String getDesc() {
        return desc;
    }
}
