package com.qiho.center.api.enums.area.code;

import com.qiho.center.api.enums.area.AreaCodeEnumerable;

import java.util.Arrays;

public enum AreaCodeHUBEnum implements AreaCodeEnumerable {
    CODE_420000("420000", "湖北省"),
    CODE_420100("420100", "湖北省武汉市"),
    CODE_420101("420101", "湖北省武汉市市辖区"),
    CODE_420102("420102", "湖北省武汉市江岸区"),
    CODE_420103("420103", "湖北省武汉市江汉区"),
    CODE_420104("420104", "湖北省武汉市乔口区"),
    CODE_420105("420105", "湖北省武汉市汉阳区"),
    CODE_420106("420106", "湖北省武汉市武昌区"),
    CODE_420107("420107", "湖北省武汉市青山区"),
    CODE_420111("420111", "湖北省武汉市洪山区"),
    CODE_420112("420112", "湖北省武汉市东西湖区"),
    CODE_420113("420113", "湖北省武汉市汉南区"),
    CODE_420114("420114", "湖北省武汉市蔡甸区"),
    CODE_420115("420115", "湖北省武汉市江夏区"),
    CODE_420116("420116", "湖北省武汉市黄陂区"),
    CODE_420117("420117", "湖北省武汉市新洲区"),
    CODE_420200("420200", "湖北省黄石市"),
    CODE_420201("420201", "湖北省黄石市市辖区"),
    CODE_420202("420202", "湖北省黄石市黄石港区"),
    CODE_420203("420203", "湖北省黄石市石灰窑区"),
    CODE_420204("420204", "湖北省黄石市下陆区"),
    CODE_420205("420205", "湖北省黄石市铁山区"),
    CODE_420222("420222", "湖北省黄石市阳新县"),
    CODE_420281("420281", "湖北省黄石市大冶市"),
    CODE_420300("420300", "湖北省十堰市"),
    CODE_420301("420301", "湖北省十堰市市辖区"),
    CODE_420302("420302", "湖北省十堰市茅箭区"),
    CODE_420303("420303", "湖北省十堰市张湾区"),
    CODE_420321("420321", "湖北省十堰市郧县"),
    CODE_420322("420322", "湖北省十堰市郧西县"),
    CODE_420323("420323", "湖北省十堰市竹山县"),
    CODE_420324("420324", "湖北省十堰市竹溪县"),
    CODE_420325("420325", "湖北省十堰市房县"),
    CODE_420381("420381", "湖北省十堰市丹江口市"),
    CODE_420500("420500", "湖北省宜昌市"),
    CODE_420501("420501", "湖北省宜昌市市辖区"),
    CODE_420502("420502", "湖北省宜昌市西陵区"),
    CODE_420503("420503", "湖北省宜昌市伍家岗区"),
    CODE_420504("420504", "湖北省宜昌市点军区"),
    CODE_420505("420505", "湖北省宜昌市虎亭区"),
    CODE_420521("420521", "湖北省宜昌市宜昌县"),
    CODE_420525("420525", "湖北省宜昌市远安县"),
    CODE_420526("420526", "湖北省宜昌市兴山县"),
    CODE_420527("420527", "湖北省宜昌市秭归县"),
    CODE_420528("420528", "湖北省宜昌市长阳土家族自治县"),
    CODE_420529("420529", "湖北省宜昌市五峰土家族自治县"),
    CODE_420581("420581", "湖北省宜昌市宜都市"),
    CODE_420582("420582", "湖北省宜昌市当阳市"),
    CODE_420583("420583", "湖北省宜昌市枝江市"),
    CODE_420600("420600", "湖北省襄樊市"),
    CODE_420601("420601", "湖北省襄樊市市辖区"),
    CODE_420602("420602", "湖北省襄樊市襄城区"),
    CODE_420606("420606", "湖北省襄樊市樊城区"),
    CODE_420621("420621", "湖北省襄樊市襄阳县"),
    CODE_420624("420624", "湖北省襄樊市南漳县"),
    CODE_420625("420625", "湖北省襄樊市谷城县"),
    CODE_420626("420626", "湖北省襄樊市保康县"),
    CODE_420682("420682", "湖北省襄樊市老河口市"),
    CODE_420683("420683", "湖北省襄樊市枣阳市"),
    CODE_420684("420684", "湖北省襄樊市宜城市"),
    CODE_420700("420700", "湖北省鄂州市"),
    CODE_420701("420701", "湖北省鄂州市市辖区"),
    CODE_420702("420702", "湖北省鄂州市梁子湖区"),
    CODE_420703("420703", "湖北省鄂州市华容区"),
    CODE_420704("420704", "湖北省鄂州市鄂城区"),
    CODE_420800("420800", "湖北省荆门市"),
    CODE_420801("420801", "湖北省荆门市市辖区"),
    CODE_420802("420802", "湖北省荆门市东宝区"),
    CODE_420821("420821", "湖北省荆门市京山县"),
    CODE_420822("420822", "湖北省荆门市沙洋县"),
    CODE_420881("420881", "湖北省荆门市钟祥市"),
    CODE_420900("420900", "湖北省孝感市"),
    CODE_420901("420901", "湖北省孝感市市辖区"),
    CODE_420902("420902", "湖北省孝感市孝南区"),
    CODE_420921("420921", "湖北省孝感市孝昌县"),
    CODE_420922("420922", "湖北省孝感市大悟县"),
    CODE_420923("420923", "湖北省孝感市云梦县"),
    CODE_420981("420981", "湖北省孝感市应城市"),
    CODE_420982("420982", "湖北省孝感市安陆市"),
    CODE_420983("420983", "湖北省孝感市广水市"),
    CODE_420984("420984", "湖北省孝感市汉川市"),
    CODE_421000("421000", "湖北省荆州市"),
    CODE_421001("421001", "湖北省荆州市市辖区"),
    CODE_421002("421002", "湖北省荆州市沙市区"),
    CODE_421003("421003", "湖北省荆州市荆州区"),
    CODE_421022("421022", "湖北省荆州市公安县"),
    CODE_421023("421023", "湖北省荆州市监利县"),
    CODE_421024("421024", "湖北省荆州市江陵县"),
    CODE_421081("421081", "湖北省荆州市石首市"),
    CODE_421083("421083", "湖北省荆州市洪湖市"),
    CODE_421087("421087", "湖北省荆州市松滋市"),
    CODE_421100("421100", "湖北省黄冈市"),
    CODE_421101("421101", "湖北省黄冈市市辖区"),
    CODE_421102("421102", "湖北省黄冈市黄州区"),
    CODE_421121("421121", "湖北省黄冈市团风县"),
    CODE_421122("421122", "湖北省黄冈市红安县"),
    CODE_421123("421123", "湖北省黄冈市罗田县"),
    CODE_421124("421124", "湖北省黄冈市英山县"),
    CODE_421125("421125", "湖北省黄冈市浠水县"),
    CODE_421126("421126", "湖北省黄冈市蕲春县"),
    CODE_421127("421127", "湖北省黄冈市黄梅县"),
    CODE_421181("421181", "湖北省黄冈市麻城市"),
    CODE_421182("421182", "湖北省黄冈市武穴市"),
    CODE_421200("421200", "湖北省咸宁市"),
    CODE_421201("421201", "湖北省咸宁市市辖区"),
    CODE_421202("421202", "湖北省咸宁市咸安区"),
    CODE_421221("421221", "湖北省咸宁市嘉鱼县"),
    CODE_421222("421222", "湖北省咸宁市通城县"),
    CODE_421223("421223", "湖北省咸宁市崇阳县"),
    CODE_421224("421224", "湖北省咸宁市通山县"),
    CODE_422800("422800", "湖北省施土家族苗族自治州"),
    CODE_422801("422801", "湖北省恩施土家族苗族自治州恩施县"),
    CODE_422802("422802", "湖北省恩施土家族苗族自治州利川市"),
    CODE_422822("422822", "湖北省恩施土家族苗族自治州建始县"),
    CODE_422823("422823", "湖北省恩施土家族苗族自治州巴东县"),
    CODE_422825("422825", "湖北省恩施土家族苗族自治州宣恩县"),
    CODE_422826("422826", "湖北省恩施土家族苗族自治州咸丰县"),
    CODE_422827("422827", "湖北省恩施土家族苗族自治州来凤县"),
    CODE_422828("422828", "湖北省恩施土家族苗族自治州鹤峰县"),
    CODE_429000("429000", "湖北省省直辖县级行政单位"),
    CODE_429001("429001", "湖北省随州市"),
    CODE_429004("429004", "湖北省仙桃市"),
    CODE_429005("429005", "湖北省潜江市"),
    CODE_429006("429006", "湖北省天门市"),
    CODE_429021("429021", "湖北省神农架林区"),;
    /** 代码 */
    private String code;

    /** 描述 */
    private String desc;

    AreaCodeHUBEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public boolean isExist(String code) {
        return Arrays.stream(values()).filter(v -> v.code.equals(code)).findFirst().isPresent();
    }
}
