package com.qiho.center.api.remoteservice.order;

import cn.com.duiba.boot.exception.BizException;
import com.qiho.center.api.dto.OrderStrategyDto;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.merchant.MerchantDto;
import com.qiho.center.api.dto.order.StrategyMerchantItemDto;
import com.qiho.center.api.params.OrderStrategyParams;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * Created by danke on 2017/6/21.
 * 踢单策略的暴露接口
 */
@AdvancedFeignClient
public interface RemoteOrderStrategyService {

    /**
     * 分页查询
     */
    DubboResult<PagenationDto<OrderStrategyDto>> queryStrategyByPage(OrderStrategyParams params, Integer pageNum,
        Integer pageSize);

    /**
     * 通过id删除
     */
    DubboResult<Boolean> deleteStrategyById(Long id, String updator);

    /**
     * 更新
     */
    DubboResult<Boolean> updateStrategyByParam(OrderStrategyDto orderStrategyDto);

    /**
     * 插入
     */
    DubboResult<Integer> insertStrategy(OrderStrategyDto orderStrategyDto);

    /**
     * 条件查询总记录数
     */
    DubboResult<Integer> countByParam(OrderStrategyParams params);

    /**
     * 删除商家策略
     *
     * @param merchantId 商家id
     * @param strategyId 策略id
     * @return 是否成功
     */
    Boolean delMerchantStrategy(Long merchantId, Long strategyId);

    /**
     * 查询商家作弊策略
     * @param merchantId
     * @param strategyId
     * @return
     */
    StrategyMerchantItemDto queryMerchantStrategyItem(Long merchantId, Long strategyId) throws BizException;


    /**
     * 模糊查找策略相关联的店铺
     * @param strategyId 策略id
     * @param name 店铺名称
     * @param operatorId 操作人id
     * @return
     */
    List<MerchantDto> findStrategyMerchantByName(Long strategyId, String name, Long operatorId) throws BizException;

    /**
     * 创建人是否是个人权限
     * @param creatorId
     * @return
     */
    Boolean isCreatorPersonal(Long creatorId) throws BizException;

    /**
     * 更新策略创建者信息
     */
    void updateStrategyCreator();
}
