package com.qiho.center.api.dto.finance;

import java.util.Date;

import com.qiho.center.api.dto.BaseDto;
import com.qiho.center.api.enums.finance.FinanceTypeEnum;

/**
 * 历史金额信息对象
 *
 * @author jiafeng.geng
 * @create 2018-03-21 20:18:46
 **/
public class HistoricalBalanceDto extends BaseDto {

    /**
     * 主键
     */
    private Long id;

    /**
     * 关联的类型 商家/代理商
     */
    private FinanceTypeEnum relationType;

    /**
     * 关联的  商家/代理商 id
     */
    private Long relationId;

    /**
     * 关联的 商家/代理商  名称
     */
    private String name;

    /**
     * 创建日期
     */
    private Date reportDate;

    /**
     * 总余额
     */
    private Long totalAmount;

    /**
     * 现金余额
     */
    private Long cashAmount;

    /**
     * 返点余额
     */
    private Long rebateAmount;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public FinanceTypeEnum getRelationType() {
        return relationType;
    }

    public void setRelationType(FinanceTypeEnum relationType) {
        this.relationType = relationType;
    }

    public Long getRelationId() {
        return relationId;
    }

    public void setRelationId(Long relationId) {
        this.relationId = relationId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Date getReportDate() {
        return reportDate;
    }

    public void setReportDate(Date reportDate) {
        this.reportDate = reportDate;
    }

    public Long getTotalAmount() {
        return totalAmount;
    }

    public void setTotalAmount(Long totalAmount) {
        this.totalAmount = totalAmount;
    }

    public Long getCashAmount() {
        return cashAmount;
    }

    public void setCashAmount(Long cashAmount) {
        this.cashAmount = cashAmount;
    }

    public Long getRebateAmount() {
        return rebateAmount;
    }

    public void setRebateAmount(Long rebateAmount) {
        this.rebateAmount = rebateAmount;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }
}
