package com.qiho.center.api.dto.item;

import java.io.Serializable;
import java.util.List;

/**
 * 商品评论扩展字段
 *
 * @author zhangbaiqiang
 * @date 2020/8/12
 */
public class ItemEvaluateExtDto implements Serializable {
    private static final long serialVersionUID = 1570695091773388116L;

    /**
     * 物流评分
     */
    private Integer logisticsRating;

    /**
     * 服务评分
     */
    private Integer serviceRating;

    /**
     * 评论等级 {@link com.qiho.center.api.enums.item.ItemEvaluateLevelEnum}
     */
    private Integer evaluateLevel;

    /**
     * 评论图片链接
     */
    private List<String> imgList;

    public Integer getLogisticsRating() {
        return logisticsRating;
    }

    public void setLogisticsRating(Integer logisticsRating) {
        this.logisticsRating = logisticsRating;
    }

    public Integer getServiceRating() {
        return serviceRating;
    }

    public void setServiceRating(Integer serviceRating) {
        this.serviceRating = serviceRating;
    }

    public Integer getEvaluateLevel() {
        return evaluateLevel;
    }

    public void setEvaluateLevel(Integer evaluateLevel) {
        this.evaluateLevel = evaluateLevel;
    }

    public List<String> getImgList() {
        return imgList;
    }

    public void setImgList(List<String> imgList) {
        this.imgList = imgList;
    }
}
