package com.qiho.center.api.enums.area.code;

import com.qiho.center.api.enums.area.AreaCodeEnumerable;

import java.util.Arrays;

public enum AreaCodeGDEnum implements AreaCodeEnumerable {
    CODE_440000("440000", "广东省"),
    CODE_440100("440100", "广东省广州市"),
    CODE_440101("440101", "广东省广州市市辖区"),
    CODE_440102("440102", "广东省广州市东山区"),
    CODE_440103("440103", "广东省广州市荔湾区"),
    CODE_440104("440104", "广东省广州市越秀区"),
    CODE_440105("440105", "广东省广州市海珠区"),
    CODE_440106("440106", "广东省广州市天河区"),
    CODE_440107("440107", "广东省广州市芳村区"),
    CODE_440111("440111", "广东省广州市白云区"),
    CODE_440112("440112", "广东省广州市黄埔区"),
    CODE_440181("440181", "广东省广州市番禺市"),
    CODE_440182("440182", "广东省广州市花都市"),
    CODE_440183("440183", "广东省广州市增城市"),
    CODE_440184("440184", "广东省广州市从化市"),
    CODE_440200("440200", "广东省韶关市"),
    CODE_440201("440201", "广东省韶关市市辖区"),
    CODE_440202("440202", "广东省韶关市北江区"),
    CODE_440203("440203", "广东省韶关市武江区"),
    CODE_440204("440204", "广东省韶关市浈江区"),
    CODE_440221("440221", "广东省韶关市曲江县"),
    CODE_440222("440222", "广东省韶关市始兴县"),
    CODE_440224("440224", "广东省韶关市仁化县"),
    CODE_440229("440229", "广东省韶关市翁源县"),
    CODE_440232("440232", "广东省韶关市乳源瑶族自治县"),
    CODE_440233("440233", "广东省韶关市新丰县"),
    CODE_440281("440281", "广东省韶关市乐昌市"),
    CODE_440282("440282", "广东省韶关市南雄市"),
    CODE_440300("440300", "广东省深圳市"),
    CODE_440301("440301", "广东省深圳市市辖区"),
    CODE_440303("440303", "广东省深圳市罗湖区"),
    CODE_440304("440304", "广东省深圳市福田区"),
    CODE_440305("440305", "广东省深圳市南山区"),
    CODE_440306("440306", "广东省深圳市宝安区"),
    CODE_440307("440307", "广东省深圳市龙岗区"),
    CODE_440308("440308", "广东省深圳市盐田区"),
    CODE_440400("440400", "广东省珠海市"),
    CODE_440401("440401", "广东省珠海市市辖区"),
    CODE_440402("440402", "广东省珠海市香洲区"),
    CODE_440421("440421", "广东省珠海市斗门县"),
    CODE_440500("440500", "广东省汕头市"),
    CODE_440501("440501", "广东省汕头市市辖区"),
    CODE_440506("440506", "广东省汕头市达濠区"),
    CODE_440507("440507", "广东省汕头市龙湖区"),
    CODE_440508("440508", "广东省汕头市金园区"),
    CODE_440509("440509", "广东省汕头市升平区"),
    CODE_440510("440510", "广东省汕头市河浦区"),
    CODE_440523("440523", "广东省汕头市南澳县"),
    CODE_440582("440582", "广东省汕头市潮阳市"),
    CODE_440583("440583", "广东省汕头市澄海市"),
    CODE_440600("440600", "广东省佛山市"),
    CODE_440601("440601", "广东省佛山市市辖区"),
    CODE_440602("440602", "广东省佛山市城区"),
    CODE_440603("440603", "广东省佛山市石湾区"),
    CODE_440681("440681", "广东省佛山市顺德市"),
    CODE_440682("440682", "广东省佛山市南海市"),
    CODE_440683("440683", "广东省佛山市三水市"),
    CODE_440684("440684", "广东省佛山市高明市"),
    CODE_440700("440700", "广东省江门市"),
    CODE_440701("440701", "广东省江门市市辖区"),
    CODE_440703("440703", "广东省江门市蓬江区"),
    CODE_440704("440704", "广东省江门市江海区"),
    CODE_440781("440781", "广东省江门市台山市"),
    CODE_440782("440782", "广东省江门市新会市"),
    CODE_440783("440783", "广东省江门市开平市"),
    CODE_440784("440784", "广东省江门市鹤山市"),
    CODE_440785("440785", "广东省江门市恩平市"),
    CODE_440800("440800", "广东省湛江市"),
    CODE_440801("440801", "广东省湛江市市辖区"),
    CODE_440802("440802", "广东省湛江市赤坎区"),
    CODE_440803("440803", "广东省湛江市霞山区"),
    CODE_440804("440804", "广东省湛江市坡头区"),
    CODE_440811("440811", "广东省湛江市麻章区"),
    CODE_440823("440823", "广东省湛江市遂溪县"),
    CODE_440825("440825", "广东省湛江市徐闻县"),
    CODE_440881("440881", "广东省湛江市廉江市"),
    CODE_440882("440882", "广东省湛江市雷州市"),
    CODE_440883("440883", "广东省湛江市吴川市"),
    CODE_440900("440900", "广东省茂名市"),
    CODE_440901("440901", "广东省茂名市市辖区"),
    CODE_440902("440902", "广东省茂名市茂南区"),
    CODE_440923("440923", "广东省茂名市电白县"),
    CODE_440981("440981", "广东省茂名市高州市"),
    CODE_440982("440982", "广东省茂名市化州市"),
    CODE_440983("440983", "广东省茂名市信宜市"),
    CODE_441200("441200", "广东省肇庆市"),
    CODE_441201("441201", "广东省肇庆市市辖区"),
    CODE_441202("441202", "广东省肇庆市端州区"),
    CODE_441203("441203", "广东省肇庆市鼎湖区"),
    CODE_441223("441223", "广东省肇庆市广宁县"),
    CODE_441224("441224", "广东省肇庆市怀集县"),
    CODE_441225("441225", "广东省肇庆市封开县"),
    CODE_441226("441226", "广东省肇庆市德庆县"),
    CODE_441283("441283", "广东省肇庆市高要市"),
    CODE_441284("441284", "广东省肇庆市四会市"),
    CODE_441300("441300", "广东省惠州市"),
    CODE_441301("441301", "广东省惠州市市辖区"),
    CODE_441302("441302", "广东省惠州市惠城区"),
    CODE_441322("441322", "广东省惠州市博罗县"),
    CODE_441323("441323", "广东省惠州市惠东县"),
    CODE_441324("441324", "广东省惠州市龙门县"),
    CODE_441381("441381", "广东省惠州市惠阳市"),
    CODE_441400("441400", "广东省梅州市"),
    CODE_441401("441401", "广东省梅州市市辖区"),
    CODE_441402("441402", "广东省梅州市梅江区"),
    CODE_441421("441421", "广东省梅州市梅县"),
    CODE_441422("441422", "广东省梅州市大埔县"),
    CODE_441423("441423", "广东省梅州市丰顺县"),
    CODE_441424("441424", "广东省梅州市五华县"),
    CODE_441426("441426", "广东省梅州市平远县"),
    CODE_441427("441427", "广东省梅州市蕉岭县"),
    CODE_441481("441481", "广东省梅州市兴宁市"),
    CODE_441500("441500", "广东省汕尾市"),
    CODE_441501("441501", "广东省汕尾市市辖区"),
    CODE_441502("441502", "广东省汕尾市城区"),
    CODE_441521("441521", "广东省汕尾市海丰县"),
    CODE_441523("441523", "广东省汕尾市陆河县"),
    CODE_441581("441581", "广东省汕尾市陆丰市"),
    CODE_441600("441600", "广东省河源市"),
    CODE_441601("441601", "广东省河源市市辖区"),
    CODE_441602("441602", "广东省河源市源城区"),
    CODE_441621("441621", "广东省河源市紫金县"),
    CODE_441622("441622", "广东省河源市龙川县"),
    CODE_441623("441623", "广东省河源市连平县"),
    CODE_441624("441624", "广东省河源市和平县"),
    CODE_441625("441625", "广东省河源市东源县"),
    CODE_441700("441700", "广东省阳江市"),
    CODE_441701("441701", "广东省阳江市市辖区"),
    CODE_441702("441702", "广东省阳江市江城区"),
    CODE_441721("441721", "广东省阳江市阳西县"),
    CODE_441723("441723", "广东省阳江市阳东县"),
    CODE_441781("441781", "广东省阳江市阳春市"),
    CODE_441800("441800", "广东省清远市"),
    CODE_441801("441801", "广东省清远市市辖区"),
    CODE_441802("441802", "广东省清远市清城区"),
    CODE_441821("441821", "广东省清远市佛冈县"),
    CODE_441823("441823", "广东省清远市阳山县"),
    CODE_441825("441825", "广东省清远市连山壮族瑶族自治县"),
    CODE_441826("441826", "广东省清远市连南瑶族自治县"),
    CODE_441827("441827", "广东省清远市清新县"),
    CODE_441881("441881", "广东省清远市英德市"),
    CODE_441882("441882", "广东省清远市连州市"),
    CODE_441900("441900", "广东省东莞市"),
    CODE_441901("441901", "广东省东莞市市辖区"),
    CODE_442000("442000", "广东省中山市"),
    CODE_442001("442001", "广东省中山市市辖区"),
    CODE_445100("445100", "广东省潮州市"),
    CODE_445101("445101", "广东省潮州市市辖区"),
    CODE_445102("445102", "广东省潮州市湘桥区"),
    CODE_445121("445121", "广东省潮州市潮安县"),
    CODE_445122("445122", "广东省潮州市饶平县"),
    CODE_445200("445200", "广东省揭阳市"),
    CODE_445201("445201", "广东省揭阳市市辖区"),
    CODE_445202("445202", "广东省揭阳市榕城区"),
    CODE_445221("445221", "广东省揭阳市揭东县"),
    CODE_445222("445222", "广东省揭阳市揭西县"),
    CODE_445224("445224", "广东省揭阳市惠来县"),
    CODE_445281("445281", "广东省揭阳市普宁市"),
    CODE_445300("445300", "广东省云浮市"),
    CODE_445301("445301", "广东省云浮市市辖区"),
    CODE_445302("445302", "广东省云浮市云城区"),
    CODE_445321("445321", "广东省云浮市新兴县"),
    CODE_445322("445322", "广东省云浮市郁南县"),
    CODE_445323("445323", "广东省云浮市云安县"),
    CODE_445381("445381", "广东省云浮市罗定市"),
    ;
    /** 代码 */
    private String code;

    /** 描述 */
    private String desc;

    AreaCodeGDEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public boolean isExist(String code) {
        return Arrays.stream(values()).filter(v -> v.code.equals(code)).findFirst().isPresent();
    }
}
