package com.qiho.center.api.enums.area.code;

import com.qiho.center.api.enums.area.AreaCodeEnumerable;

import java.util.Arrays;

public enum AreaCodeGXEnum implements AreaCodeEnumerable {
    CODE_450000("450000", "广西壮族自治区"),
    CODE_450100("450100", "广西壮族自治区南宁市"),
    CODE_450101("450101", "广西壮族自治区南宁市市辖区"),
    CODE_450102("450102", "广西壮族自治区南宁市兴宁区"),
    CODE_450103("450103", "广西壮族自治区南宁市新城区"),
    CODE_450104("450104", "广西壮族自治区南宁市城北区"),
    CODE_450105("450105", "广西壮族自治区南宁市江南区"),
    CODE_450106("450106", "广西壮族自治区南宁市永新区"),
    CODE_450111("450111", "广西壮族自治区南宁市市郊区"),
    CODE_450121("450121", "广西壮族自治区南宁市邕宁县"),
    CODE_450122("450122", "广西壮族自治区南宁市武鸣县"),
    CODE_450200("450200", "广西壮族自治区柳州市"),
    CODE_450201("450201", "广西壮族自治区柳州市市辖区"),
    CODE_450202("450202", "广西壮族自治区柳州市城中区"),
    CODE_450203("450203", "广西壮族自治区柳州市鱼峰区"),
    CODE_450204("450204", "广西壮族自治区柳州市柳南区"),
    CODE_450205("450205", "广西壮族自治区柳州市柳北区"),
    CODE_450211("450211", "广西壮族自治区柳州市市郊区"),
    CODE_450221("450221", "广西壮族自治区柳州市柳江县"),
    CODE_450222("450222", "广西壮族自治区柳州市柳城县"),
    CODE_450300("450300", "广西壮族自治区桂林市"),
    CODE_450301("450301", "广西壮族自治区桂林市市辖区"),
    CODE_450302("450302", "广西壮族自治区桂林市秀峰区"),
    CODE_450303("450303", "广西壮族自治区桂林市叠彩区"),
    CODE_450304("450304", "广西壮族自治区桂林市象山区"),
    CODE_450305("450305", "广西壮族自治区桂林市七星区"),
    CODE_450311("450311", "广西壮族自治区桂林市雁山区"),
    CODE_450321("450321", "广西壮族自治区桂林市阳朔县"),
    CODE_450322("450322", "广西壮族自治区桂林市临桂县"),
    CODE_450323("450323", "广西壮族自治区桂林市灵川县"),
    CODE_450324("450324", "广西壮族自治区桂林市全州县"),
    CODE_450325("450325", "广西壮族自治区桂林市兴安县"),
    CODE_450326("450326", "广西壮族自治区桂林市永福县"),
    CODE_450327("450327", "广西壮族自治区桂林市灌阳县"),
    CODE_450328("450328", "广西壮族自治区桂林市龙胜各族自治县"),
    CODE_450329("450329", "广西壮族自治区桂林市资源县"),
    CODE_450330("450330", "广西壮族自治区桂林市平乐县"),
    CODE_450331("450331", "广西壮族自治区桂林市荔浦县"),
    CODE_450332("450332", "广西壮族自治区桂林市恭城瑶族自治县"),
    CODE_450400("450400", "广西壮族自治区梧州市"),
    CODE_450401("450401", "广西壮族自治区梧州市市辖区"),
    CODE_450403("450403", "广西壮族自治区梧州市万秀区"),
    CODE_450404("450404", "广西壮族自治区梧州市蝶山区"),
    CODE_450411("450411", "广西壮族自治区梧州市市郊区"),
    CODE_450421("450421", "广西壮族自治区梧州市苍梧县"),
    CODE_450422("450422", "广西壮族自治区梧州市藤县"),
    CODE_450423("450423", "广西壮族自治区梧州市蒙山县"),
    CODE_450481("450481", "广西壮族自治区梧州市岑溪市"),
    CODE_450500("450500", "广西壮族自治区北海市"),
    CODE_450501("450501", "广西壮族自治区北海市市辖区"),
    CODE_450502("450502", "广西壮族自治区北海市海城区"),
    CODE_450503("450503", "广西壮族自治区北海市银海区"),
    CODE_450512("450512", "广西壮族自治区北海市铁山港区"),
    CODE_450521("450521", "广西壮族自治区北海市合浦县"),
    CODE_450600("450600", "广西壮族自治区防城港市"),
    CODE_450601("450601", "广西壮族自治区防城港市市辖区"),
    CODE_450602("450602", "广西壮族自治区防城港市港口区"),
    CODE_450603("450603", "广西壮族自治区防城港市防城区"),
    CODE_450621("450621", "广西壮族自治区防城港市上思县"),
    CODE_450681("450681", "广西壮族自治区防城港市东兴市"),
    CODE_450700("450700", "广西壮族自治区钦州市"),
    CODE_450701("450701", "广西壮族自治区钦州市市辖区"),
    CODE_450702("450702", "广西壮族自治区钦州市钦南区"),
    CODE_450703("450703", "广西壮族自治区钦州市钦北区"),
    CODE_450721("450721", "广西壮族自治区钦州市灵山县"),
    CODE_450722("450722", "广西壮族自治区钦州市浦北县"),
    CODE_450800("450800", "广西壮族自治区贵港市"),
    CODE_450801("450801", "广西壮族自治区贵港市市辖区"),
    CODE_450802("450802", "广西壮族自治区贵港市港北区"),
    CODE_450803("450803", "广西壮族自治区贵港市港南区"),
    CODE_450821("450821", "广西壮族自治区贵港市平南县"),
    CODE_450881("450881", "广西壮族自治区贵港市桂平市"),
    CODE_450900("450900", "广西壮族自治区玉林市"),
    CODE_450901("450901", "广西壮族自治区玉林市市辖区"),
    CODE_450902("450902", "广西壮族自治区玉林市玉州区"),
    CODE_450921("450921", "广西壮族自治区玉林市容县"),
    CODE_450922("450922", "广西壮族自治区玉林市陆川县"),
    CODE_450923("450923", "广西壮族自治区玉林市博白县"),
    CODE_450924("450924", "广西壮族自治区玉林市兴业县"),
    CODE_450981("450981", "广西壮族自治区玉林市北流市"),
    CODE_452100("452100", "广西壮族自治区南宁地区"),
    CODE_452101("452101", "广西壮族自治区南宁地区凭祥市"),
    CODE_452122("452122", "广西壮族自治区南宁地区横县"),
    CODE_452123("452123", "广西壮族自治区南宁地区宾阳县"),
    CODE_452124("452124", "广西壮族自治区南宁地区上林县"),
    CODE_452126("452126", "广西壮族自治区南宁地区隆安县"),
    CODE_452127("452127", "广西壮族自治区南宁地区马山县"),
    CODE_452128("452128", "广西壮族自治区南宁地区扶绥县"),
    CODE_452129("452129", "广西壮族自治区南宁地区崇左县"),
    CODE_452130("452130", "广西壮族自治区南宁地区大新县"),
    CODE_452131("452131", "广西壮族自治区南宁地区天等县"),
    CODE_452132("452132", "广西壮族自治区南宁地区宁明县"),
    CODE_452133("452133", "广西壮族自治区南宁地区龙州县"),
    CODE_452200("452200", "广西壮族自治区柳州地区"),
    CODE_452201("452201", "广西壮族自治区柳州地区合山市"),
    CODE_452223("452223", "广西壮族自治区柳州地区鹿寨县"),
    CODE_452224("452224", "广西壮族自治区柳州地区象州县"),
    CODE_452225("452225", "广西壮族自治区柳州地区武宣县"),
    CODE_452226("452226", "广西壮族自治区柳州地区来宾县"),
    CODE_452227("452227", "广西壮族自治区柳州地区融安县"),
    CODE_452228("452228", "广西壮族自治区柳州地区三江侗族自治县"),
    CODE_452229("452229", "广西壮族自治区柳州地区融水苗族自治县"),
    CODE_452230("452230", "广西壮族自治区柳州地区金秀瑶族自治县"),
    CODE_452231("452231", "广西壮族自治区柳州地区忻城县"),
    CODE_452400("452400", "广西壮族自治区贺州地区"),
    CODE_452402("452402", "广西壮族自治区贺州地区贺州市"),
    CODE_452424("452424", "广西壮族自治区贺州地区昭平县"),
    CODE_452427("452427", "广西壮族自治区贺州地区钟山县"),
    CODE_452428("452428", "广西壮族自治区贺州地区富川瑶族自治县"),
    CODE_452600("452600", "广西壮族自治区百色地区"),
    CODE_452601("452601", "广西壮族自治区百色地区百色市"),
    CODE_452622("452622", "广西壮族自治区百色地区田阳县"),
    CODE_452623("452623", "广西壮族自治区百色地区田东县"),
    CODE_452624("452624", "广西壮族自治区百色地区平果县"),
    CODE_452625("452625", "广西壮族自治区百色地区德保县"),
    CODE_452626("452626", "广西壮族自治区百色地区靖西县"),
    CODE_452627("452627", "广西壮族自治区百色地区那坡县"),
    CODE_452628("452628", "广西壮族自治区百色地区凌云县"),
    CODE_452629("452629", "广西壮族自治区百色地区乐业县"),
    CODE_452630("452630", "广西壮族自治区百色地区田林县"),
    CODE_452631("452631", "广西壮族自治区百色地区隆林各族自治县"),
    CODE_452632("452632", "广西壮族自治区百色地区西林县"),
    CODE_452700("452700", "广西壮族自治区河池地区"),
    CODE_452701("452701", "广西壮族自治区河池地区河池市"),
    CODE_452702("452702", "广西壮族自治区河池地区宜州市"),
    CODE_452723("452723", "广西壮族自治区河池地区罗城仫佬族自治县"),
    CODE_452724("452724", "广西壮族自治区河池地区环江毛南族自治县"),
    CODE_452725("452725", "广西壮族自治区河池地区南丹县"),
    CODE_452726("452726", "广西壮族自治区河池地区天峨县"),
    CODE_452727("452727", "广西壮族自治区河池地区凤山县"),
    CODE_452728("452728", "广西壮族自治区河池地区东兰县"),
    CODE_452729("452729", "广西壮族自治区河池地区巴马瑶族自治县"),
    CODE_452730("452730", "广西壮族自治区河池地区都安瑶族自治县"),
    CODE_452731("452731", "广西壮族自治区河池地区大化瑶族自治县"),
    ;
    /** 代码 */
    private String code;

    /** 描述 */
    private String desc;

    AreaCodeGXEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }
    @Override
    public boolean isExist(String code) {
        return Arrays.stream(values()).filter(v -> v.code.equals(code)).findFirst().isPresent();
    }
}
