package com.qiho.center.api.enums.area.code;

import com.qiho.center.api.enums.area.AreaCodeEnumerable;

import java.util.Arrays;

public enum AreaCodeSDEnum implements AreaCodeEnumerable {
    CODE_370000("370000", "山东省"),
    CODE_370100("370100", "山东省济南市"),
    CODE_370101("370101", "山东省济南市市辖区"),
    CODE_370102("370102", "山东省济南市历下区"),
    CODE_370103("370103", "山东省济南市市中区"),
    CODE_370104("370104", "山东省济南市槐荫区"),
    CODE_370105("370105", "山东省济南市天桥区"),
    CODE_370112("370112", "山东省济南市历城区"),
    CODE_370123("370123", "山东省济南市长清县"),
    CODE_370124("370124", "山东省济南市平阴县"),
    CODE_370125("370125", "山东省济南市济阳县"),
    CODE_370126("370126", "山东省济南市商河县"),
    CODE_370181("370181", "山东省济南市章丘市"),
    CODE_370200("370200", "山东省青岛市"),
    CODE_370201("370201", "山东省青岛市市辖区"),
    CODE_370202("370202", "山东省青岛市市南区"),
    CODE_370203("370203", "山东省青岛市市北区"),
    CODE_370205("370205", "山东省青岛市四方区"),
    CODE_370211("370211", "山东省青岛市黄岛区"),
    CODE_370212("370212", "山东省青岛市崂山区"),
    CODE_370213("370213", "山东省青岛市李沧区"),
    CODE_370214("370214", "山东省青岛市城阳区"),
    CODE_370281("370281", "山东省青岛市胶州市"),
    CODE_370282("370282", "山东省青岛市即墨市"),
    CODE_370283("370283", "山东省青岛市平度市"),
    CODE_370284("370284", "山东省青岛市胶南市"),
    CODE_370285("370285", "山东省青岛市莱西市"),
    CODE_370300("370300", "山东省淄博市"),
    CODE_370301("370301", "山东省淄博市市辖区"),
    CODE_370302("370302", "山东省淄博市淄川区"),
    CODE_370303("370303", "山东省淄博市张店区"),
    CODE_370304("370304", "山东省淄博市博山区"),
    CODE_370305("370305", "山东省淄博市临淄区"),
    CODE_370306("370306", "山东省淄博市周村区"),
    CODE_370321("370321", "山东省淄博市桓台县"),
    CODE_370322("370322", "山东省淄博市高青县"),
    CODE_370323("370323", "山东省淄博市沂源县"),
    CODE_370400("370400", "山东省枣庄市"),
    CODE_370401("370401", "山东省枣庄市市辖区"),
    CODE_370402("370402", "山东省枣庄市市中区"),
    CODE_370403("370403", "山东省枣庄市薛城区"),
    CODE_370404("370404", "山东省枣庄市峄城区"),
    CODE_370405("370405", "山东省枣庄市台儿庄区"),
    CODE_370406("370406", "山东省枣庄市山亭区"),
    CODE_370481("370481", "山东省枣庄市滕州市"),
    CODE_370500("370500", "山东省东营市"),
    CODE_370501("370501", "山东省东营市市辖区"),
    CODE_370502("370502", "山东省东营市东营区"),
    CODE_370503("370503", "山东省东营市河口区"),
    CODE_370521("370521", "山东省东营市垦利县"),
    CODE_370522("370522", "山东省东营市利津县"),
    CODE_370523("370523", "山东省东营市广饶县"),
    CODE_370600("370600", "山东省烟台市"),
    CODE_370601("370601", "山东省烟台市市辖区"),
    CODE_370602("370602", "山东省烟台市芝罘区"),
    CODE_370611("370611", "山东省烟台市福山区"),
    CODE_370612("370612", "山东省烟台市牟平区"),
    CODE_370613("370613", "山东省烟台市莱山区"),
    CODE_370634("370634", "山东省烟台市长岛县"),
    CODE_370681("370681", "山东省烟台市龙口市"),
    CODE_370682("370682", "山东省烟台市莱阳市"),
    CODE_370683("370683", "山东省烟台市莱州市"),
    CODE_370684("370684", "山东省烟台市蓬莱市"),
    CODE_370685("370685", "山东省烟台市招远市"),
    CODE_370686("370686", "山东省烟台市栖霞市"),
    CODE_370687("370687", "山东省烟台市海阳市"),
    CODE_370700("370700", "山东省潍坊市"),
    CODE_370701("370701", "山东省潍坊市市辖区"),
    CODE_370702("370702", "山东省潍坊市潍城区"),
    CODE_370703("370703", "山东省潍坊市寒亭区"),
    CODE_370704("370704", "山东省潍坊市坊子区"),
    CODE_370705("370705", "山东省潍坊市奎文区"),
    CODE_370724("370724", "山东省潍坊市临朐县"),
    CODE_370725("370725", "山东省潍坊市昌乐县"),
    CODE_370781("370781", "山东省潍坊市青州市"),
    CODE_370782("370782", "山东省潍坊市诸城市"),
    CODE_370783("370783", "山东省潍坊市寿光市"),
    CODE_370784("370784", "山东省潍坊市安丘市"),
    CODE_370785("370785", "山东省潍坊市高密市"),
    CODE_370786("370786", "山东省潍坊市昌邑市"),
    CODE_370800("370800", "山东省济宁市"),
    CODE_370801("370801", "山东省济宁市市辖区"),
    CODE_370802("370802", "山东省济宁市市中区"),
    CODE_370811("370811", "山东省济宁市任城区"),
    CODE_370826("370826", "山东省济宁市微山县"),
    CODE_370827("370827", "山东省济宁市鱼台县"),
    CODE_370828("370828", "山东省济宁市金乡县"),
    CODE_370829("370829", "山东省济宁市嘉祥县"),
    CODE_370830("370830", "山东省济宁市汶上县"),
    CODE_370831("370831", "山东省济宁市泗水县"),
    CODE_370832("370832", "山东省济宁市梁山县"),
    CODE_370881("370881", "山东省济宁市曲阜市"),
    CODE_370882("370882", "山东省济宁市兖州市"),
    CODE_370883("370883", "山东省济宁市邹城市"),
    CODE_370900("370900", "山东省泰安市"),
    CODE_370901("370901", "山东省泰安市市辖区"),
    CODE_370902("370902", "山东省泰安市泰山区"),
    CODE_370911("370911", "山东省泰安市郊区"),
    CODE_370921("370921", "山东省泰安市宁阳县"),
    CODE_370923("370923", "山东省泰安市东平县"),
    CODE_370982("370982", "山东省泰安市新泰市"),
    CODE_370983("370983", "山东省泰安市肥城市"),
    CODE_371000("371000", "山东省威海市"),
    CODE_371001("371001", "山东省威海市市辖区"),
    CODE_371002("371002", "山东省威海市环翠区"),
    CODE_371081("371081", "山东省威海市文登市"),
    CODE_371082("371082", "山东省威海市荣成市"),
    CODE_371083("371083", "山东省威海市乳山市"),
    CODE_371100("371100", "山东省日照市"),
    CODE_371101("371101", "山东省日照市市辖区"),
    CODE_371102("371102", "山东省日照市东港区"),
    CODE_371121("371121", "山东省日照市五莲县"),
    CODE_371122("371122", "山东省日照市莒县"),
    CODE_371200("371200", "山东省莱芜市"),
    CODE_371201("371201", "山东省莱芜市市辖区"),
    CODE_371202("371202", "山东省莱芜市莱城区"),
    CODE_371203("371203", "山东省莱芜市钢城区"),
    CODE_371300("371300", "山东省临沂市"),
    CODE_371301("371301", "山东省临沂市市辖区"),
    CODE_371302("371302", "山东省临沂市兰山区"),
    CODE_371311("371311", "山东省临沂市罗庄区"),
    CODE_371312("371312", "山东省临沂市河东区"),
    CODE_371321("371321", "山东省临沂市沂南县"),
    CODE_371322("371322", "山东省临沂市郯城县"),
    CODE_371323("371323", "山东省临沂市沂水县"),
    CODE_371324("371324", "山东省临沂市苍山县"),
    CODE_371325("371325", "山东省临沂市费县"),
    CODE_371326("371326", "山东省临沂市平邑县"),
    CODE_371327("371327", "山东省临沂市莒南县"),
    CODE_371328("371328", "山东省临沂市蒙阴县"),
    CODE_371329("371329", "山东省临沂市临沭县"),
    CODE_371400("371400", "山东省德州市"),
    CODE_371401("371401", "山东省德州市市辖区"),
    CODE_371402("371402", "山东省德州市德城区"),
    CODE_371421("371421", "山东省德州市陵县"),
    CODE_371422("371422", "山东省德州市宁津县"),
    CODE_371423("371423", "山东省德州市庆云县"),
    CODE_371424("371424", "山东省德州市临邑县"),
    CODE_371425("371425", "山东省德州市齐河县"),
    CODE_371426("371426", "山东省德州市平原县"),
    CODE_371427("371427", "山东省德州市夏津县"),
    CODE_371428("371428", "山东省德州市武城县"),
    CODE_371481("371481", "山东省德州市乐陵市"),
    CODE_371482("371482", "山东省德州市禹城市"),
    CODE_371500("371500", "山东省聊城市"),
    CODE_371501("371501", "山东省聊城市市辖区"),
    CODE_371502("371502", "山东省聊城市东昌府区"),
    CODE_371521("371521", "山东省聊城市阳谷县"),
    CODE_371522("371522", "山东省聊城市莘县"),
    CODE_371523("371523", "山东省聊城市茌平县"),
    CODE_371524("371524", "山东省聊城市东阿县"),
    CODE_371525("371525", "山东省聊城市冠县"),
    CODE_371526("371526", "山东省聊城市高唐县"),
    CODE_371581("371581", "山东省聊城市临清市"),
    CODE_372300("372300", "山东省滨州地区"),
    CODE_372301("372301", "山东省滨州地区滨州市"),
    CODE_372321("372321", "山东省滨州地区惠民县"),
    CODE_372323("372323", "山东省滨州地区阳信县"),
    CODE_372324("372324", "山东省滨州地区无棣县"),
    CODE_372325("372325", "山东省滨州地区沾化县"),
    CODE_372328("372328", "山东省滨州地区博兴县"),
    CODE_372330("372330", "山东省滨州地区邹平县"),
    CODE_372900("372900", "山东省菏泽地区"),
    CODE_372901("372901", "山东省菏泽地区菏泽市"),
    CODE_372922("372922", "山东省菏泽地区曹县"),
    CODE_372923("372923", "山东省菏泽地区定陶县"),
    CODE_372924("372924", "山东省菏泽地区成武县"),
    CODE_372925("372925", "山东省菏泽地区单县"),
    CODE_372926("372926", "山东省菏泽地区巨野县"),
    CODE_372928("372928", "山东省菏泽地区郓城县"),
    CODE_372929("372929", "山东省菏泽地区鄄城县"),
    CODE_372930("372930", "山东省菏泽地区东明县"),;
    /** 代码 */
    private String code;

    /** 描述 */
    private String desc;

    AreaCodeSDEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }
    @Override
    public boolean isExist(String code) {
        return Arrays.stream(values()).filter(v -> v.code.equals(code)).findFirst().isPresent();
    }
}
