package com.qiho.center.api.remoteservice.merchant;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.qiho.center.api.dto.SimpleIdAndNameDto;
import com.qiho.center.api.dto.merchant.MerchantAdvertDto;

import java.util.Date;
import java.util.List;

/**
 * 商家广告后台服务
 *
 * @author peanut.huang
 * @date 2017/12/28.
 */
@AdvancedFeignClient
public interface RemoteMerchantAdvertBackendService {

    /**
     * 查询所有商家(包含关联广告主与未关联广告主)
     *
     * @param merchantId   商家id 精准查询
     * @return
     */
    List<MerchantAdvertDto> findAll(Long merchantId);

    /**
     * 查询未关联商家的广告主
     *
     * @return
     */
    List<SimpleIdAndNameDto> findUnLinkedAdvert();

    /**
     * 插入商家与广告主关联
     *
     * @param merchantAdvertDto   实体
     * @return
     */
    Boolean insertMerchantAdvert(MerchantAdvertDto merchantAdvertDto) throws BizException;

    /**
     * 查询时间段内商家广告消耗量
     *
     * @param merchantId     商家id
     * @param startDate      查询开始日期
     * @param endDate        查询结束日期
     * @return
     */
    List<MerchantAdvertDto> findAdvertConsume(Long merchantId, Date startDate, Date endDate);
}
