package com.qiho.center.api.dto.qualification;

import com.qiho.center.api.enums.shop.ShopAuditEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author Wangpf
 * @description
 * @date 2020/8/7 10:33 上午
 */
@Data
public class ShopQualificationDto implements Serializable {

    /**
     * 关联的店铺ID
     */
    private Long shopId;

    /**
     * 资质审核状态
     */
    private Integer auditStatus;

    /**
     * SSO审核人ID
     */
    private String ssoAuditName;

    /**
     * 拒绝原因
     */
    private String rejectReason;

    /**
     * 业务模式 1-在线支付 2-货到付款 3-在线支付&货到付款
     */
    private Integer businessModel;

    /**
     * 营业执照链接
     */
    private String businessLicense;

    /**
     * 其他营业执照链接，多个链接用逗号进行分割
     */
    private String otherBusinessLicense;

    /**
     * 公司名称
     */
    private String companyName;

    /**
     * 一级目录ID集合
     */
    private List<Long> categoryIdList;

    /**
     * 店铺名称
     */
    private String shopName;

    /**
     * 负责人名称
     */
    private String ownerAeName;

    /**
     * 审核时间
     */
    private String auditTime;

    /**
     * 审核类型
     */
    private String auditType = ShopAuditEnum.SHOP_QUALIFICATION_AUDIT.getAuditType();
}
