package com.qiho.center.api.enums.area.code;

import com.qiho.center.api.enums.area.AreaCodeEnumerable;

import java.util.Arrays;

public enum AreaCodeJNEnum implements AreaCodeEnumerable {
    CODE_220000("220000", "吉林省"),
    CODE_220100("220100", "吉林省长春市"),
    CODE_220101("220101", "吉林省长春市市辖区"),
    CODE_220102("220102", "吉林省长春市南关区"),
    CODE_220103("220103", "吉林省长春市宽城区"),
    CODE_220104("220104", "吉林省长春市朝阳区"),
    CODE_220105("220105", "吉林省长春市二道区"),
    CODE_220106("220106", "吉林省长春市绿园区"),
    CODE_220112("220112", "吉林省长春市双阳区"),
    CODE_220122("220122", "吉林省长春市农安县"),
    CODE_220181("220181", "吉林省长春市九台市"),
    CODE_220182("220182", "吉林省长春市榆树市"),
    CODE_220183("220183", "吉林省长春市德惠市"),
    CODE_220200("220200", "吉林省吉林市"),
    CODE_220201("220201", "吉林省吉林市市辖区"),
    CODE_220202("220202", "吉林省吉林市昌邑区"),
    CODE_220203("220203", "吉林省吉林市龙潭区"),
    CODE_220204("220204", "吉林省吉林市船营区"),
    CODE_220211("220211", "吉林省吉林市丰满区"),
    CODE_220221("220221", "吉林省吉林市永吉县"),
    CODE_220281("220281", "吉林省吉林市蛟河市"),
    CODE_220282("220282", "吉林省吉林市桦甸市"),
    CODE_220283("220283", "吉林省吉林市舒兰市"),
    CODE_220284("220284", "吉林省吉林市磐石市"),
    CODE_220300("220300", "吉林省四平市"),
    CODE_220301("220301", "吉林省四平市市辖区"),
    CODE_220302("220302", "吉林省四平市铁西区"),
    CODE_220303("220303", "吉林省四平市铁东区"),
    CODE_220322("220322", "吉林省四平市梨树县"),
    CODE_220323("220323", "吉林省四平市伊通满族自治县"),
    CODE_220381("220381", "吉林省四平市公主岭市"),
    CODE_220382("220382", "吉林省四平市双辽市"),
    CODE_220400("220400", "吉林省辽源市"),
    CODE_220401("220401", "吉林省辽源市市辖区"),
    CODE_220402("220402", "吉林省辽源市龙山区"),
    CODE_220403("220403", "吉林省辽源市西安区"),
    CODE_220421("220421", "吉林省辽源市东丰县"),
    CODE_220422("220422", "吉林省辽源市东辽县"),
    CODE_220500("220500", "吉林省通化市"),
    CODE_220501("220501", "吉林省通化市市辖区"),
    CODE_220502("220502", "吉林省通化市东昌区"),
    CODE_220503("220503", "吉林省通化市二道江区"),
    CODE_220521("220521", "吉林省通化市通化县"),
    CODE_220523("220523", "吉林省通化市辉南县"),
    CODE_220524("220524", "吉林省通化市柳河县"),
    CODE_220581("220581", "吉林省通化市梅河口市"),
    CODE_220582("220582", "吉林省通化市集安市"),
    CODE_220600("220600", "吉林省白山市"),
    CODE_220601("220601", "吉林省白山市市辖区"),
    CODE_220602("220602", "吉林省白山市八道江区"),
    CODE_220621("220621", "吉林省白山市抚松县"),
    CODE_220622("220622", "吉林省白山市靖宇县"),
    CODE_220623("220623", "吉林省白山市长白朝鲜族自治县"),
    CODE_220625("220625", "吉林省白山市江源县"),
    CODE_220681("220681", "吉林省白山市临江市"),
    CODE_220700("220700", "吉林省松原市"),
    CODE_220701("220701", "吉林省松原市市辖区"),
    CODE_220702("220702", "吉林省松原市宁江区"),
    CODE_220721("220721", "吉林省松原市前郭尔罗斯蒙古族自治县"),
    CODE_220722("220722", "吉林省松原市长岭县"),
    CODE_220723("220723", "吉林省松原市乾安县"),
    CODE_220724("220724", "吉林省松原市扶余县"),
    CODE_220800("220800", "吉林省白城市"),
    CODE_220801("220801", "吉林省白城市市辖区"),
    CODE_220802("220802", "吉林省白城市洮北区"),
    CODE_220821("220821", "吉林省白城市镇赉县"),
    CODE_220822("220822", "吉林省白城市通榆县"),
    CODE_220881("220881", "吉林省白城市洮南市"),
    CODE_220882("220882", "吉林省白城市大安市"),
    CODE_222400("222400", "吉林省延边朝鲜族自治州"),
    CODE_222401("222401", "吉林省延边朝鲜族自治州延吉市"),
    CODE_222402("222402", "吉林省延边朝鲜族自治州图们市"),
    CODE_222403("222403", "吉林省延边朝鲜族自治州敦化市"),
    CODE_222404("222404", "吉林省延边朝鲜族自治州珲春市"),
    CODE_222405("222405", "吉林省延边朝鲜族自治州龙井市"),
    CODE_222406("222406", "吉林省延边朝鲜族自治州和龙市"),
    CODE_222424("222424", "吉林省延边朝鲜族自治州汪清县"),
    CODE_222426("222426", "吉林省延边朝鲜族自治州安图县"),
    ;
    /** 代码 */
    private String code;

    /** 描述 */
    private String desc;

    AreaCodeJNEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }
    @Override
    public boolean isExist(String code) {
        return Arrays.stream(values()).filter(v -> v.code.equals(code)).findFirst().isPresent();
    }
}
