package com.qiho.center.api.remoteservice.advert;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.advert.ItemAdvertPlanDto;
import com.qiho.center.api.dto.advert.TuiaPlanDto;
import com.qiho.center.api.params.advert.ItemBindPlanParams;
import com.qiho.center.api.params.advert.ItemPlanQueryParams;

import java.util.List;

/**商品广告计划服务远程接口
 * @author chensong
 * @create 2018-01-08 13:43
 **/
@AdvancedFeignClient
public interface RemoteItemPlanService {

    /**
     * 分页查询
     * @param params
     * @return
     */
    PagenationDto<ItemAdvertPlanDto> queryPage(ItemPlanQueryParams params);

    /**
     * 获取广告主未绑定广告计划
     * @param itemId 广告主id
     * @return
     */
    List<TuiaPlanDto> getUnbindPlan(Long itemId);

    /**
     * 关联广告计划
     * @param params
     * @return
     */
    Boolean bingPlan(ItemBindPlanParams params) throws BizException;


}
