package com.qiho.center.api.enums;

import org.apache.commons.lang.StringUtils;

/**
 * Created by chensong on 2017/10/11 0011.
 */
public enum AfterSaleOrderStageEnum {

    TO_APPROVE("TO_APPROVE","待审核","发起售后，等待审核"),

    PASS_APPROVE("PASS_APPROVE","审核通过","审核通过，请将商品寄回并提交物流信息，不接受到付件"),

    SUBMIT_LOGISTICS("SUBMIT_LOGISTICS","提交物流信息","物流信息已提交，等待奇货商城收货"),

    ITEM_RECEIVE("ITEM_RECEIVE","商品收到","商品已收到，正在退款"),

    REFUND_SUCCESS("REFUND_SUCCESS","退款成功","退款成功，资金将按付款方式返回,预计1-5个工作日完成"),

    CANCEL("CANCEL","取消售后","售后取消"),

    PAY_AGAIN("PAY_AGAIN", "重新打款", "重新打款"),

    AGREE("AGREE", "同意退货退款", "请将商品寄回并提交物流信息，不接受到付件"),

    HAVE_MONEY("HAVE_MONEY", "已人工打款", "已线下打款"),

    REJECT_REFUND("REJECT_REFUND", "退款拒绝", "申请被拒绝，请重新申请");


    private String code;
    private String msg;
    private String copy;

    AfterSaleOrderStageEnum(String code, String msg, String copy) {
        this.code = code;
        this.msg = msg;
        this.copy = copy;
    }

    public String getCopy(){
        return copy;
    }

    public String getCode() {
        return code;
    }

    public String getMsg() {
        return msg;
    }

    public static AfterSaleOrderStageEnum getByCode(String code) {
        for (AfterSaleOrderStageEnum enumVal : AfterSaleOrderStageEnum.values()) {
            if (StringUtils.equals(code, enumVal.getCode())) {
                return enumVal;
            }
        }
        return null;
    }

}
