package com.qiho.center.api.remoteservice.qualification;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.qualification.ShopQualificationDto;
import com.qiho.center.api.params.qualification.ShopQualificationPageParam;

/**
 * @author Wangpf
 * @description
 * @date 2020/8/7 10:56 上午
 */
@AdvancedFeignClient
public interface RemoteShopQualificationService {

    /**
     * 保存资质
     *
     * @param shopQualificationDto
     * @return
     */
    int saveOrUpdateShopQualification(ShopQualificationDto shopQualificationDto);

    /**
     * 更新资质
     *
     * @param shopQualificationDto
     * @return
     */
    int updateShopQualification(ShopQualificationDto shopQualificationDto);


    /**
     * 分页查询店铺资质
     *
     * @param shopQualificationPageParam
     * @return
     */
    PagenationDto<ShopQualificationDto>  pageQuery(ShopQualificationPageParam shopQualificationPageParam);

    /**
     * 通过资质
     *
     * @param shopQualificationDto
     * @return
     */
    boolean passShopQualification(ShopQualificationDto shopQualificationDto) throws BizException;

    /**
     * 拒绝资质
     *
     * @param shopQualificationDto
     * @return
     */
    boolean rejectShopQualification(ShopQualificationDto shopQualificationDto) throws BizException;

    /**
     * 根据店铺Id 查询店铺的资质信息
     *
     * @param shopId
     * @return
     */
    ShopQualificationDto findShopQualificationByShopId(Long shopId);
}
