package com.qiho.center.api.dto.menu;

import java.util.Objects;

/**
 * AccountMenuContextDto 缓存使用
 *
 * @author zhangshun
 * @version V1.0
 * @since 2017-12-07 18:42
 */
public class AccountMenuCacheDto extends MenuDto {

    private static final long serialVersionUID = 5458695020346322505L;

    private Long accountId;
    private Long menuId;
    private Byte flag; //0=无权限、1=有权限

    public Long getAccountId() {
        return accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public Long getMenuId() {
        return menuId;
    }

    public void setMenuId(Long menuId) {
        this.menuId = menuId;
    }

    public Byte getFlag() {
        return flag;
    }

    public void setFlag(Byte flag) {
        this.flag = flag;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o)
            return true;
        if (o == null || getClass() != o.getClass())
            return false;
        if (!super.equals(o))
            return false;
        AccountMenuCacheDto that = (AccountMenuCacheDto) o;
        return Objects.equals(accountId, that.accountId) && Objects.equals(menuId, that.menuId) && Objects
            .equals(flag, that.flag);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), accountId, menuId, flag);
    }

    @Override
    public String toString() {
        return "AccountMenuCacheDto{" + "accountId=" + accountId + ", menuId=" + menuId + ", flag=" + flag + '}';
    }
}
