package com.qiho.center.api.enums.finance;

/**
 * 商户类型
 * Author: zhanghuifeng
 * Date:   15:12 2017/12/20
 */
public enum BaiqiCommercialTenantTypeEnum {
	MERCHANT(1,"商家"),
	AGENT(2,"代理商");

	private int type;

	private String desc;

	BaiqiCommercialTenantTypeEnum(int type, String desc){
		this.type = type;
		this.desc = desc;
	}

	public static BaiqiCommercialTenantTypeEnum getByType(int type){
		for (BaiqiCommercialTenantTypeEnum value : BaiqiCommercialTenantTypeEnum.values()) {
			if (value.getType() == type) {
				return value;
			}
		}
		return null;
	}

	public int getType() {
		return type;
	}

	public String getDesc() {
		return desc;
	}
}
