package com.qiho.center.api.enums.order;

import com.qiho.center.api.enums.AfterSaleOrderStatusEnum;
import lombok.AllArgsConstructor;
import lombok.Getter;
import org.apache.commons.lang.StringUtils;

import java.util.HashMap;
import java.util.Map;

/**
 * @author huangruodan
 * @version 创建时间：2020/10/20 4:08 下午
 */
@Getter
@AllArgsConstructor
public enum AfterSaleOrderSubStatusEnum {
    TO_COMFIRM("TO_COMFIRM", "申请中"),
    REFUND_REJECT("REFUND_REJECT", "退款拒绝"),
    TO_BE_RETURN("TO_BE_RETURN", "待退货"),
    TO_BE_RECEIVE("TO_BE_RECEIVE", "待收货"),
    RETURN_PRODUCT_REJECT("RETURN_PRODUCT_REJECT", "退货拒绝"),
    TO_BE_REFUND("TO_BE_REFUND", "退款中"),
    REFUND_FAIL("REFUND_FAIL","退款失败"),
    REFUND_CANCEL("REFUND_CANCEL", "退款取消"),
    REFUND_SUCCESS("REFUND_SUCCESS", "退款成功");


    private String status;

    private String desc;

    static Map<String, AfterSaleOrderSubStatusEnum> statusEnumMap = new HashMap<>();
    static Map<String, AfterSaleOrderStatusEnum> subStatusMap = new HashMap<>();

    static {
        statusEnumMap.put(AfterSaleOrderStatusEnum.CANCLE.getCode(), AfterSaleOrderSubStatusEnum.REFUND_CANCEL);
        statusEnumMap.put(AfterSaleOrderStatusEnum.TO_COMFIRM.getCode(), AfterSaleOrderSubStatusEnum.TO_COMFIRM);
        statusEnumMap.put(AfterSaleOrderStatusEnum.SUCCESS.getCode(), AfterSaleOrderSubStatusEnum.REFUND_SUCCESS);

        subStatusMap.put(AfterSaleOrderSubStatusEnum.REFUND_CANCEL.getStatus(), AfterSaleOrderStatusEnum.CANCLE);
        subStatusMap.put(AfterSaleOrderSubStatusEnum.TO_COMFIRM.getStatus(), AfterSaleOrderStatusEnum.TO_COMFIRM);
        subStatusMap.put(AfterSaleOrderSubStatusEnum.REFUND_SUCCESS.getStatus(), AfterSaleOrderStatusEnum.SUCCESS);

        subStatusMap.put(AfterSaleOrderSubStatusEnum.REFUND_REJECT.getStatus(), AfterSaleOrderStatusEnum.AFTER_SALEING);
        subStatusMap.put(AfterSaleOrderSubStatusEnum.TO_BE_RETURN.getStatus(), AfterSaleOrderStatusEnum.AFTER_SALEING);
        subStatusMap.put(AfterSaleOrderSubStatusEnum.TO_BE_RECEIVE.getStatus(), AfterSaleOrderStatusEnum.AFTER_SALEING);
        subStatusMap.put(AfterSaleOrderSubStatusEnum.RETURN_PRODUCT_REJECT.getStatus(), AfterSaleOrderStatusEnum.AFTER_SALEING);
        subStatusMap.put(AfterSaleOrderSubStatusEnum.TO_BE_REFUND.getStatus(), AfterSaleOrderStatusEnum.AFTER_SALEING);
        subStatusMap.put(AfterSaleOrderSubStatusEnum.REFUND_FAIL.getStatus(), AfterSaleOrderStatusEnum.AFTER_SALEING);


    }

    public static AfterSaleOrderSubStatusEnum getByCode(String code) {
        for (AfterSaleOrderSubStatusEnum enumVal : AfterSaleOrderSubStatusEnum.values()) {
            if (StringUtils.equals(code, enumVal.getStatus())) {
                return enumVal;
            }
        }
        return null;
    }

    public static String getSubStatusByAfterSaleStatus(String afterStatus) {
        AfterSaleOrderSubStatusEnum afterSaleOrderSubStatusEnum = statusEnumMap.get(afterStatus);
        if (afterSaleOrderSubStatusEnum == null) {
            return "";
        }
        return afterSaleOrderSubStatusEnum.getStatus();
    }

    public static String getStatusByAfterSaleSubStatus(String subStatus) {
        AfterSaleOrderStatusEnum statusEnum = subStatusMap.get(subStatus);
        if (statusEnum == null) {
            return "";
        }
        return statusEnum.getCode();
    }
}
