package com.qiho.center.api.enums.security;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Objects;

/**
 * @author huangruodan
 * @version 创建时间：2020/8/20 2:25 下午
 */
@AllArgsConstructor
@Getter
public enum SecurityFundApplyStatusEnum {

    FINANCE_ASSISTANT_APPROVING(1, "财务助理审批中"),
    FINANCE_ASSISTANT_APPROVE_REJECT(2, "财务助理审批拒绝"),
    FINANCE_MANAGER_APPROVING(3, "财务主管审批中"),
    FINANCE_MANAGER_APPROVE_REJECT(4, "财务主管审批拒绝"),
    FINISH(5, "完成");

    private Integer status;
    private String desc;

    public static String getDescByStatus(Integer status) {
        for (SecurityFundApplyStatusEnum type : SecurityFundApplyStatusEnum.values()) {
            if (Objects.equals(type.getStatus(), status)) {
                return type.getDesc();
            }
        }
        return null;
    }
}
