package com.qiho.center.api.remoteservice.data;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.data.ConsumeDataDto;
import com.qiho.center.api.dto.data.ItemDataDto;
import com.qiho.center.api.dto.data.MerchantDataOrderDto;
import com.qiho.center.api.dto.data.OverAllDataDto;
import com.qiho.center.api.params.data.ConsumeOrderDataQueryParam;
import com.qiho.center.api.params.data.OrderDataQueryParam;

/**
 * @author Wangpf
 * @description
 * @date 2020/2/25 11:32 AM
 */
@AdvancedFeignClient
public interface RemoteMerchantDataService {

    /**
     * 商家数据总揽接口
     *
     * @return
     */
    OverAllDataDto overall(Long merchantId);

    /**
     * 商家订单数据查询
     *
     * @param orderDataParam
     * @return
     */
    MerchantDataOrderDto order(OrderDataQueryParam orderDataParam);

    /**
     * 商品数据查询
     *
     * @param merchantId
     * @return
     */
    ItemDataDto item(Long merchantId);

    /**
     * 消耗数据查询
     *
     * @param consumeOrderDataParam
     * @return
     */
    PagenationDto<ConsumeDataDto> consume(ConsumeOrderDataQueryParam consumeOrderDataParam);
}
