package com.qiho.center.api.remoteservice.menu;

import com.qiho.center.api.dto.menu.AccountMenuDto;
import com.qiho.center.api.params.menu.AccountMenuParams;

import java.util.List;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * 用户菜单API接口
 *
 * @author zhangshun
 * @version V1.0
 * @since 2017-12-07 16:13
 */
@AdvancedFeignClient
public interface RemoteAccountMenuService {

    /**
     * 批量保存用户菜单
     *
     * @param menuIdList
     * @return
     * @throws cn.com.duiba.boot.exception.BizException
     */
    Boolean saveAccountMenuList(Long accountId, Integer accountType, String accountName, List<Long> menuIdList)
        throws BizException;

    /**
     * 修改用户菜单
     *
     * @param accountId
     * @param accountType
     * @param menuIdList
     * @return
     * @throws cn.com.duiba.boot.exception.BizException
     */
    Boolean updateAccountMenuList(Long accountId, Integer accountType, String accountName, List<Long> menuIdList)
        throws BizException;

    /**
     * 删除用户菜单
     *
     * @param accountId
     * @param accountType
     * @return
     * @throws cn.com.duiba.boot.exception.BizException
     */
    Integer deleteByAccountId(Long accountId, Integer accountType, String accountName) throws BizException;

    /**
     * 条件查询,
     * <p>如果是主账号，数据包含账号及账号管理.</p>
     * <p>如果是子账号，数据不包含账号及账号管理，并选中用户已有的菜单</p>
     *
     * @param params
     * @return
     * @throws cn.com.duiba.boot.exception.BizException
     */
    List<AccountMenuDto> findByParam(AccountMenuParams params) throws BizException;

    /**
     * 条件查询 返回 tree
     * <p>
     * <p>如果是主账号，数据包含账号及账号管理.</p>
     * <p>如果是子账号，数据不包含账号及账号管理，并选中用户已有的菜单</p>
     *
     * @param params
     * @return
     * @throws cn.com.duiba.boot.exception.BizException
     */
    List<AccountMenuDto> findByParamAsTree(AccountMenuParams params) throws BizException;

    /**
     * 条件查询
     *
     * @param accountId 用户id
     * @param menuId    菜单id
     * @return
     * @throws cn.com.duiba.boot.exception.BizException
     */
    boolean isOperationByAccountIdAndMenuId(Long accountId, Integer accountType, Long menuId);

    /**
     * 根据用户查询，只返回用户已有的菜单
     *
     * @param accountId
     * @return
     * @throws cn.com.duiba.boot.exception.BizException
     */
    List<AccountMenuDto> findByAccountId(Long accountId, Integer accountType) throws BizException;

}
