package com.qiho.center.api.dto.trading.statistics;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author Wangpf
 * @description
 * @date 2020/9/2 10:22 上午
 */
@Data
public class ShopTradingStatisticsDto implements Serializable {

    /**
     * 主键Id
     */
    private Long id;

    /**
     * 店铺Id
     */
    private Long shopId;

    /**
     * 订单总数
     */
    private Long orderCount;

    /**
     * 账期总金额
     */
    private Long paymentDaysTotalAmount;

    /**
     * 手续费，单位：分
     */
    private Integer poundageAmt;

    /**
     * 退款总金额 单位：分
     */
    private Integer refundTotalAmt;

    /**
     * 已经结算总金额，单位：分
     */
    private Integer settledAmount;

    /**
     * 待结算总金额，单位：分
     */
    private Integer waitSettleAmount;

    /**
     * 已经提现总金额，单位：分
     */
    private Integer alreadyWithdrawalAmount;

    /**
     * 待提现总金额，单位：分
     */
    private Integer waitWithdrawalAmount;

    /**
     * 创建时间
     */
    private String gmtCreate;

    /**
     * 修改时间
     */
    private String gmtModified;

    /**
     * 店铺名称
     */
    private String shopName;

    /**
     * 公司名称
     */
    private String companyName;
}
