package com.qiho.center.api.enums;

import com.google.common.collect.Maps;

import java.util.Map;

/**
 * Created by liuyao on 2017/5/22.
 * 维护万能黑名单的bkType
 */
public enum BlackListEnum {

    YUAN_TONG_COD("YUAN_TONG","圆通货到付款配送地区黑名单"),
    
    PHONE_NUMBER("PHONENO","手机号码黑名单"),
    
    REGION("REGION","地区黑名单"),

    YUAN_TONG_PAIED("YUAN_TONG_PAIED","圆通普通快递（在线支付）不配送地区黑名单"),

    PHONE_ORDER("PHONE_ORDER","手机号下单黑名单");


    private static Map<String,BlackListEnum> blackMap = Maps.newHashMap();
    static {
        for(BlackListEnum it:BlackListEnum.values()){
            blackMap.put(it.getBkType(),it);
        }
    }

    private String bkType;
    private String describe;

    BlackListEnum(String bkType,String describe){
        this.bkType = bkType;
        this.describe = describe;
    }


    public static BlackListEnum getEnumByType(String type){
        return blackMap.get(type);
    }

    public String getBkType() {
        return bkType;
    }

    public String getDescribe() {
        return describe;
    }

}
