package com.qiho.center.api.remoteservice.area;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.area.BatchSaveMerchantAreaDto;
import com.qiho.center.api.dto.area.MerchantAreaDataDto;
import com.qiho.center.api.dto.area.MerchantAreaDto;
import com.qiho.center.api.dto.area.MerchantAreaQueryParam;

/**
 * @author huangruodan
 * @version 创建时间：2021/2/22 下午4:57
 */
@AdvancedFeignClient
public interface RemoteMerchantAreaService {

    /**
     * 批量保存商户地址
     * @param merchantArea
     * @return 是否成功
     */
    Long batchSaveMerchantArea(BatchSaveMerchantAreaDto merchantArea) throws BizException;

    /**
     * 根据商品id获取地域信息
     * @param itemId
     * @return
     */
    MerchantAreaDataDto getMerchantAreaByItemId(Long itemId) throws BizException;

    /**
     * 删除商家地址
     * @param id
     * @return
     */
    Boolean deleteMerchantArea(Long id) throws BizException;

    /**
     * 查询列表
     * @param query
     * @return
     */
    PagenationDto<MerchantAreaDto> getListByQuery(MerchantAreaQueryParam query) throws BizException;

    /**
     * 查询商户详情
     * @param id
     * @return
     */
    MerchantAreaDto getById(Long id) throws BizException;
}
