/**
 * Project Name:qiho-center-api
 * File Name:RemoteFundOrderService.java
 * Package Name:com.qiho.center.api.remoteservice.order
 * Date:2017年6月6日下午12:57:04
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package com.qiho.center.api.remoteservice.order;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;

import com.qiho.center.api.dto.FundOrderDto;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.params.FundPageParam;

/**
 * ClassName:RemoteFundOrderService <br/>
 * 资金流水Dubbo服务. <br/>
 * Date:     2017年6月6日 下午12:57:04 <br/>
 * @author   zhanglihui
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@AdvancedFeignClient
public interface RemoteFundOrderService {

    /**
     * 根据订单ID查询资金流水
     *
     * @author zhanglihui
     * @param orderId
     * @return List<FundOrderDto>
     */
    DubboResult<List<FundOrderDto>> findByOrderId(String orderId);
    
    /**
     * 分页查询资金流水
     * @author zhanglihui
     * @param param
     * @return PagenationDto<FundOrderDto>
     */
    DubboResult<PagenationDto<FundOrderDto>> queryFundPage(FundPageParam param);
    
    /**
     * 根据订单ID和资金业务类型查询资金订单
     *
     * @author zhanglihui
     * @param orderId 订单ID
     * @param bizType 资金业务类型
     * @return List<FundOrderDto>
     */
    DubboResult<List<FundOrderDto>> findByOrderIdAndBizType(String orderId, String bizType);
    
    /**
     * 通知资金订单支付成功，更新主订单和资金子订单状态，并自动审批通过
     *
     * @author zhanglihui
     * @param fundOrder          更新后的自定子订单
     * @param originalFundStatus 待更新资金订单状态，根据ID+状态保证幂等
     * @return DubboResult
     */
    DubboResult<Void> notifySuccess(FundOrderDto fundOrder, String originalFundStatus);
    
    /**
     * 根据订单ID发起退款流程
     *
     * @author zhanglihui
     * @param orderId 订单ID
     * @param payType 支付类型
     * @param amt     退款金额,单位：分
     * @return DubboResult
     */
    DubboResult<Void> refund(String orderId, String payType, Integer amt);
    
    /**
     * 更新资金订单付款方式
     *
     * @author zhanglihui
     * @param fundOrder 
     * @param originalFundStatus 
     * @return DubboResult
     */
    DubboResult<Void> updatePayType(FundOrderDto fundOrder, String originalFundStatus);

    /**
     * 通过资金子订单id查询资金子订单
     */
    DubboResult<FundOrderDto> findByFundId(String fundId);


    DubboResult<Void> updateFundOrder(FundOrderDto fundOrder);
}

