/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.api.util;

import com.google.common.collect.Lists;
import com.qiho.center.api.exception.QihoException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MD5Facade {
    private static Logger logger = LoggerFactory.getLogger(MD5Facade.class);

    private MD5Facade() {
    }

    public static boolean validateFormDataParamMD5(Map<String, String> dataMap, String securityKey, String currentSignature) {
        if (dataMap == null) {
            return false;
        }
        Set<String> keySet = dataMap.keySet();
        ArrayList keyList = Lists.newArrayList(keySet);
        Collections.sort(keyList);
        StringBuilder toMD5StringBuilder = new StringBuilder();
        for (String key : keyList) {
            String value = dataMap.get(key);
            if (value == null || value.length() <= 0) continue;
            toMD5StringBuilder.append(key + "=" + value + "&");
        }
        try {
            String securityKeyMD5 = MD5.md5(securityKey, "");
            toMD5StringBuilder.append(securityKeyMD5);
            String toMD5String = toMD5StringBuilder.toString();
            String actualMD5Value = MD5.md5(toMD5String, "");
            return actualMD5Value.equals(currentSignature);
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static String getFormDataParamMD5(Map<String, String> dataMap, String securityKey, String charset) {
        if (dataMap == null) {
            return null;
        }
        Set<String> keySet = dataMap.keySet();
        ArrayList keyList = Lists.newArrayList(keySet);
        Collections.sort(keyList);
        StringBuilder toMD5StringBuilder = new StringBuilder();
        for (String key : keyList) {
            String value = dataMap.get(key);
            if (value == null || value.length() <= 0) continue;
            toMD5StringBuilder.append(key + "=" + value + "&");
        }
        try {
            String securityKeyMD5 = MD5.md5(securityKey, charset);
            toMD5StringBuilder.append(securityKeyMD5);
            String toMD5String = toMD5StringBuilder.toString();
            logger.info("\u5f85MD5\u7b7e\u540d\u5b57\u7b26\u4e32 = {}", (Object)toMD5String);
            String lastMD5Result = MD5.md5(toMD5String, charset);
            logger.info("MD5\u7b7e\u540d\u540e\u5b57\u7b26\u4e32 = {}", (Object)lastMD5Result);
            return lastMD5Result;
        }
        catch (Exception ex) {
            return "";
        }
    }

    public static class MD5 {
        private MD5() {
        }

        public static String md5(String text, String charset) {
            try {
                String newCharSet = StringUtils.isBlank((String)charset) ? "UTF-8" : charset;
                byte[] bytes = text.getBytes(newCharSet);
                MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                messageDigest.update(bytes);
                bytes = messageDigest.digest();
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < bytes.length; ++i) {
                    if ((bytes[i] & 0xFF) < 16) {
                        sb.append("0");
                    }
                    sb.append(Long.toString(bytes[i] & 0xFF, 16));
                }
                return sb.toString().toLowerCase();
            }
            catch (Exception e) {
                logger.error("MD5Facade call md5 error", (Throwable)e);
                throw new QihoException();
            }
        }

        public static boolean verify(String text, String charset, String md5) {
            String md5Text = MD5.md5(text, charset);
            return md5Text.equalsIgnoreCase(md5);
        }
    }
}

