package com.qiho.center.api.dto.bklist;

import com.google.common.collect.Lists;
import com.qiho.center.api.dto.BaseDto;
import com.qiho.center.api.dto.merchant.MerchantSimpleDto;
import com.qiho.center.api.enums.DealTypeEnum;
import com.qiho.center.api.enums.blacklist.BaiqiBlackListTypeEnum;
import com.qiho.center.api.enums.blacklist.BlackListUseTypeEnum;

import java.util.Date;
import java.util.List;

/** 黑名单策略实体
 * @author chensong
 * @create 2018-04-24 11:45
 **/
public class BlackListStrategyDto extends BaseDto {

    /** id */
    private Long id;

    /** 策略 */
    private StrategyDto strategy;

    /** 黑名单策略类型 */
    private BaiqiBlackListTypeEnum bkType;

    /** 适用类型 */
    private BlackListUseTypeEnum useType;

    /** 最后修改人 */
    private String operator;

    /** 处理方式 */
    private DealTypeEnum dealType;

    /** 删除标识 */
    private Boolean deleted;

    /** 商家信息 */
    private List<MerchantSimpleDto> merchantList;

    /** 商家id集合 */
    private List<Long> merchantIdList;

    /** 创建时间 */
    private Date gmtCreate;

    /** 修改时间 */
    private Date gmtModified;

    public List<Long> getMerchantIdList() {
        return merchantIdList;
    }

    public void setMerchantIdList(List<Long> merchantIdList) {
        this.merchantIdList = merchantIdList;
    }

    /**
     * 设置商家信息
     * @param merchantId
     * @param merchantName
     */
    public void setMerchant(Long merchantId, String merchantName){
        if (merchantList == null) {
            MerchantSimpleDto merchantSimpleDto = new MerchantSimpleDto(merchantId,merchantName);
            merchantList = Lists.newArrayList(merchantSimpleDto);
        } else {
            merchantList.add(new MerchantSimpleDto(merchantId, merchantName));
        }
    }

    public StrategyDto getStrategy() {
        return strategy;
    }

    public void setStrategy(StrategyDto strategy) {
        this.strategy = strategy;
    }

    public List<MerchantSimpleDto> getMerchantList() {
        return merchantList;
    }

    public void setMerchantList(List<MerchantSimpleDto> merchantList) {
        this.merchantList = merchantList;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public BaiqiBlackListTypeEnum getBkType() {
        return bkType;
    }

    public void setBkType(BaiqiBlackListTypeEnum bkType) {
        this.bkType = bkType;
    }

    public BlackListUseTypeEnum getUseType() {
        return useType;
    }

    public void setUseType(BlackListUseTypeEnum useType) {
        this.useType = useType;
    }

    public String getOperator() {
        return operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public DealTypeEnum getDealType() {
        return dealType;
    }

    public void setDealType(DealTypeEnum dealType) {
        this.dealType = dealType;
    }

    public Boolean getDeleted() {
        return deleted;
    }

    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }
}
