package com.qiho.center.api.dto.order;

import lombok.Data;

import java.io.Serializable;

/**
 * @author huangruodan
 * @version 创建时间：2020/10/20 4:27 下午
 */
@Data
public class AfterSaleOrderDetailDto implements Serializable {

    private static final long serialVersionUID = -7793866934148835056L;
    /**
     * 售后订单
     */
    private String afterSaleId;

    /**
     * 退款类型 {@link com.qiho.center.api.enums.AfterSaleOrderTypeEnum}
     */
    private String afterSaleType;

    /**
     * 售后订单状态 {@link com.qiho.center.api.enums.AfterSaleOrderStatusEnum}
     */
    private String afterSaleStatus;

    /**
     * 售后订单子状态 {@link com.qiho.center.api.enums.order.AfterSaleOrderSubStatusEnum}
     */
    private String afterSaleSubStatus;


    /**
     * 备注
     */
    private String remark;

    /**
     * 订单金额
     */
    private Long orderAmt;

    /**
     * 退款金额
     */
    private Long refundAmount;

    /**
     * 支付类型 {@link com.qiho.center.api.enums.PayTypeEnum}
     */
    private String payType;

    /**
     * 商家地址
     */
    private String merchantAddress;

    /**
     * 付款链接
     */
    private String payRecordUrl;

    /**
     * 售后原因 {@link com.qiho.center.api.enums.AfterSaleOrderReasonEnum}
     */
    private String afterSaleReason;

    /**
     * 商家说明
     */
    private String merchantDesc;

    /**
     * 物流单号
     */
    private String postId;

    /**
     * 物流公司编码
     */
    private String logisticCode;
}
