package com.qiho.center.api.dto.order;

import com.qiho.center.api.enums.order.OrderOperatorTypeEnum;
import org.hibernate.validator.constraints.NotBlank;

import java.io.Serializable;

/**
 * 单笔
 * Created by weny.cai on 2018/3/15.
 */
public class OrderCancelDto implements Serializable {

    @NotBlank
    private String orderId;

    /** 订单备注信息 */
    private String remark;

    /**
     * 操作人类型 {@link OrderOperatorTypeEnum}
     */
    private Integer operatorType;

    private String operator;

    public String getOperator() {
        return operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public String getOrderId() {
        return orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Integer getOperatorType() {
        return operatorType;
    }

    public void setOperatorType(Integer operatorType) {
        this.operatorType = operatorType;
    }
}
