package com.qiho.center.api.enums;

import org.apache.commons.lang.StringUtils;

/**
 * Created by danke on 2017/10/9.
 * 售后子订单状态枚举 待审核|待确认|售后中|售后完成|售后取消
 */
public enum AfterSaleOrderStatusEnum {

    TO_APPROVE("TO_APPROVE","待审核"),
    TO_COMFIRM("TO_COMFIRM","待确认"),
    AFTER_SALEING("AFTER_SALEING","售后中"),
    SUCCESS("SUCCESS","售后完成"),
    CANCLE("CANCLE","售后取消");

    private String code;
    private String msg;

    AfterSaleOrderStatusEnum(String code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    /**
     * @param code
     * @return DatabaseSchema
     */
    public static AfterSaleOrderStatusEnum getByCode(String code) {
        for (AfterSaleOrderStatusEnum enumVal : AfterSaleOrderStatusEnum.values()) {
            if (StringUtils.equals(code, enumVal.getCode())) {
                return enumVal;
            }
        }
        return null;
    }

    public static String getMsgByCode(String code) {
        AfterSaleOrderStatusEnum orderStatusEnum = getByCode(code);
        if (orderStatusEnum == null) {
            return "";
        }
        return orderStatusEnum.getMsg();
    }

    public String getCode() {
        return code;
    }

    public String getMsg() {
        return msg;
    }
}
