package com.qiho.center.api.enums.ShotOrder;

import com.google.common.collect.Lists;

import java.util.List;

/** 订单校验对象与匹配条件的适配器
 * @author chensong
 * @create 2018-04-18 15:54
 **/
public class ShotOrderFieldEnumAdapter {

    private ShotOrderFieldEnumAdapter(){
    }

    /**
     * 根据策略类型获取对应的匹配规则
     * @param field
     * @return
     */
    public static List<ShotOrderRuleEnum> listRule(ShotOrderFieldEnum field){
        List<ShotOrderRuleEnum> orderRuleEnumList = Lists.newArrayList();
        if (null == field){
            return orderRuleEnumList;
        }
        switch (field){
            case PLACE_ORDER_TIME:   // 页面停留时长
            case COUNT_QUANTITY:     // 订单件数
            case ADRESS_LENGTH:      // 详细地址的长度
                orderRuleEnumList = Lists.newArrayList(ShotOrderRuleEnum.GREATER_THAN,ShotOrderRuleEnum.GREATER_EQUALS,
                        ShotOrderRuleEnum.LESS_EQUALS,ShotOrderRuleEnum.LESS_THAN,ShotOrderRuleEnum.EQUALS_THAN);
                break;
            case LEAVE_WORDS:     // 用户留言
            case SKU_NO:          // 货号
            case TUIA_ID:         // 推啊id
                orderRuleEnumList = Lists.newArrayList(ShotOrderRuleEnum.CONTAINS_THAN,ShotOrderRuleEnum.NOT_CONTAINS_THAN);
                break;
            case REPEAT_ORDER_PHONE:               // 24小时下单量(手机号统计)
            case REPEAT_ORDER_TUIAID:              // 24小时下单量(推啊id统计)
            case REPEAT_ORDER_IP:                  // 24小时下单量(ip统计)
            case REPEAT_ORDER_PHONE_ITEM:          // 24小时下单量(同一手机号同一商品)
            case REPEAT_ORDER_PHONE_MERCHANT:      // 24小时下单量(同一手机号同一商家)
            case REPEAT_ORDER_TUIACID:             // 24小时下单量(推啊用户id统计)
            case MOBILE_DUPLICATE_HIT:             // 手机号多次命中现有规则
            case ID_CARD_COUNT:                    // 24小时下单量(身份证号统计)
            case ID_CARD_ITEM:                     // 24小时下单量(同一身份证，同一商品)
            case ID_CARD_MERCHANT:                 // 24小时下单量(同一身份证，同一店铺)
                orderRuleEnumList = Lists.newArrayList(ShotOrderRuleEnum.GREATER_EQUALS,ShotOrderRuleEnum.GREATER_THAN);
                break;
            case ITEM_ID:    // 商品id
                orderRuleEnumList = Lists.newArrayList(ShotOrderRuleEnum.EQUALS_THAN);
                break;
            case ADDRESS:         //详细地址
                orderRuleEnumList = Lists.newArrayList(ShotOrderRuleEnum.NOT_CONTAINS_THAN,ShotOrderRuleEnum.CONTAINS_THAN,
                        ShotOrderRuleEnum.CONTAINS_COMMA,ShotOrderRuleEnum.NOT_CONTAIN_CN);
                break;
            case CONSUMER_NAME:   // 收件人姓名
                orderRuleEnumList = Lists.newArrayList(ShotOrderRuleEnum.NOT_CONTAINS_THAN, ShotOrderRuleEnum.CONTAINS_THAN,
                    ShotOrderRuleEnum.CONTAINS_COMMA, ShotOrderRuleEnum.NOT_CONTAIN_CN, ShotOrderRuleEnum.NOT_ONLY_CN);
                break;
            case INVALID_ADDRESS:
                orderRuleEnumList = Lists.newArrayList(ShotOrderRuleEnum.ADDRESS_INVALID);
                break;
            case PHONE_STATUS:
                orderRuleEnumList = Lists.newArrayList(ShotOrderRuleEnum.EMPTY_NUM,ShotOrderRuleEnum.UN_KNOWS,
                        ShotOrderRuleEnum.CLOSE_DOWN,ShotOrderRuleEnum.BLACKLIST, ShotOrderRuleEnum.TIME_OUT);
                break;
            case IP_MOBILE_ADDRESS_CHECK:
                orderRuleEnumList = Lists.newArrayList(ShotOrderRuleEnum.ALL_DIFFER,ShotOrderRuleEnum.MOBILE_ADDRESS_DIFFER,
                ShotOrderRuleEnum.MOBILE_ADDRESS_DIFFER_CITY);
            break;
            case DELIVERY_REGION_EXCLUSIVE:
                orderRuleEnumList = Lists.newArrayList(ShotOrderRuleEnum.ADDRESS_OUT_OF_RANGE);
                break;
            case ID_CARD_AGE:
                orderRuleEnumList = Lists.newArrayList(ShotOrderRuleEnum.ID_CARD_AGE_GREATER_THAN, ShotOrderRuleEnum.ID_CARD_AGE_LESS_THAN);
                break;
            case ID_CARD_FORMAT:
                orderRuleEnumList = Lists.newArrayList(ShotOrderRuleEnum.ID_CARD_FORMAT_INVALID);
                break;
            case ID_CARD_AREA:
                orderRuleEnumList = Lists.newArrayList(ShotOrderRuleEnum.ID_CARD_AREA_INVALID);
                break;
            case ID_CARD_NAME:
                orderRuleEnumList = Lists.newArrayList(ShotOrderRuleEnum.ID_NAME_INVALID);
                break;
            case MOBILE_QUALIFICATION:
                orderRuleEnumList = Lists.newArrayList(ShotOrderRuleEnum.MOBILE_QUALIFICATION_INVALID);
                break;
            case KAISU_ID_CARD_NAME:
            case BAIQI_ID_CARD_NAME:
            case YIZUN_CARD_NAME:
                orderRuleEnumList = Lists.newArrayList(ShotOrderRuleEnum.ID_NAME_INVALID);
                break;
            case UNICOM_CARD_RISK_CONTROL:
                orderRuleEnumList = Lists.newArrayList(ShotOrderRuleEnum.HIT_UNICOM_CARD_RISK_CONTROL);
                break;
            case MOBILE_FLOW_PACKET_CALIBRATION:
                orderRuleEnumList = Lists.newArrayList(ShotOrderRuleEnum.MOBILE_QUALIFICATION_INVALID);
                break;
            case ZUOYEBANG_OVERSOLD:
                orderRuleEnumList = Lists.newArrayList(ShotOrderRuleEnum.ZUOYEBANG_OVERSOLD);
                break;
            case MOBILE_CUSTOM_API_CONFIG:
                orderRuleEnumList = Lists.newArrayList(ShotOrderRuleEnum.CUSTOM_CONFIG_ERROR);
                break;
            case ADDRESS_CUSTOM_API_CONFIG:
                orderRuleEnumList = Lists.newArrayList(ShotOrderRuleEnum.CUSTOM_CONFIG_ERROR);
                break;
            case ID_CARD_CUSTOM_API_CONFIG:
                orderRuleEnumList = Lists.newArrayList(ShotOrderRuleEnum.CUSTOM_CONFIG_ERROR);
                break;
            case CONSUMER_NAME_CUSTOM_API_CONFIG:
                orderRuleEnumList = Lists.newArrayList(ShotOrderRuleEnum.CUSTOM_CONFIG_ERROR);
                break;
            case DELIVERY_REGION_CUSTOM_API_CONFIG:
                orderRuleEnumList = Lists.newArrayList(ShotOrderRuleEnum.CUSTOM_CONFIG_ERROR);
                break;

            default:
                break;
        }
        return orderRuleEnumList;
    }

    /**
     * 根据命中的下单规则字段
     * 获取对应的下单失败文案
     * @param field
     * @return
     */
    public static String getFailOrderText(ShotOrderFieldEnum field){
        String text = "订单提交失败";
        if (null == field){
            return text;
        }
        switch (field){
            case PLACE_ORDER_TIME:    // 页面停留时长
                text = "下单失败，请重新提交订单";
                break;
            case LEAVE_WORDS:    // 用户留言
                text = "用户留言不规范";
                break;
            case COUNT_QUANTITY:     // 订单件数
                text = "订单数量";
                break;
            case ADDRESS:           //详细地址
            case ADRESS_LENGTH:     // 详细地址的长度
                text = "详细地址不符合规范";
                break;
            case CONSUMER_NAME:   // 收件人姓名
                text = "收件人姓名不符合规范";
                break;
            case REPEAT_ORDER_PHONE:               // 24小时下单量(手机号统计)
            case REPEAT_ORDER_IP:                  // 24小时下单量(ip统计)
            case REPEAT_ORDER_TUIAID:              // 24小时下单量(推啊id统计)
            case REPEAT_ORDER_PHONE_ITEM:          // 24小时下单量(同一手机号同一商品)
            case REPEAT_ORDER_PHONE_MERCHANT:      // 24小时下单量(同一手机号同一商家)
            case REPEAT_ORDER_TUIACID:             // 24小时下单量(推啊用户id统计)
                text = "您已经下过单了，请勿重复下单";
                break;
            case TUIA_ID:         // 推啊id
            case SKU_NO:          // 货号
            case ITEM_ID:         // 商品id
                text = "";
                break;
            default:
                break;

        }
        return text;
    }

    /**
     * 根据规则类型获取可以适用的order field
     * @param strategyType
     * @return
     */
    public static List<ShotOrderFieldEnum> listOrderField(StrategyType strategyType){
        List<ShotOrderFieldEnum> fieldList = Lists.newArrayList();
        if (null == strategyType){
            return fieldList;
        }

        switch (strategyType){

            case SHOT_ORDER:  // 踢单规则
                fieldList = Lists.newArrayList(ShotOrderFieldEnum.TUIA_ID, ShotOrderFieldEnum.PLACE_ORDER_TIME, ShotOrderFieldEnum.LEAVE_WORDS,
                        ShotOrderFieldEnum.COUNT_QUANTITY, ShotOrderFieldEnum.CONSUMER_NAME, ShotOrderFieldEnum.ADDRESS, ShotOrderFieldEnum.SKU_NO,
                        ShotOrderFieldEnum.ITEM_ID, ShotOrderFieldEnum.REPEAT_ORDER_PHONE, ShotOrderFieldEnum.REPEAT_ORDER_TUIAID, ShotOrderFieldEnum.ADRESS_LENGTH,
                        ShotOrderFieldEnum.REPEAT_ORDER_IP, ShotOrderFieldEnum.PHONE_STATUS, ShotOrderFieldEnum.INVALID_ADDRESS, ShotOrderFieldEnum.REPEAT_ORDER_PHONE_ITEM,
                        ShotOrderFieldEnum.REPEAT_ORDER_PHONE_MERCHANT, ShotOrderFieldEnum.IP_MOBILE_ADDRESS_CHECK, ShotOrderFieldEnum.REPEAT_ORDER_TUIACID);
                break;

            case AHEAD_PREVENT_ORDER:   // 下单规则
                fieldList = Lists.newArrayList(ShotOrderFieldEnum.TUIA_ID, ShotOrderFieldEnum.PLACE_ORDER_TIME, ShotOrderFieldEnum.LEAVE_WORDS,
                        ShotOrderFieldEnum.COUNT_QUANTITY, ShotOrderFieldEnum.CONSUMER_NAME, ShotOrderFieldEnum.ADDRESS, ShotOrderFieldEnum.SKU_NO,
                        ShotOrderFieldEnum.ITEM_ID, ShotOrderFieldEnum.REPEAT_ORDER_PHONE, ShotOrderFieldEnum.REPEAT_ORDER_TUIAID, ShotOrderFieldEnum.ADRESS_LENGTH,
                        ShotOrderFieldEnum.REPEAT_ORDER_IP,  ShotOrderFieldEnum.REPEAT_ORDER_PHONE_ITEM,
                        ShotOrderFieldEnum.REPEAT_ORDER_PHONE_MERCHANT);
                break;

            case FILTER_ORDER_RULE:   // 过滤规则
                fieldList = Lists.newArrayList(ShotOrderFieldEnum.TUIA_ID, ShotOrderFieldEnum.PLACE_ORDER_TIME, ShotOrderFieldEnum.LEAVE_WORDS,
                        ShotOrderFieldEnum.COUNT_QUANTITY, ShotOrderFieldEnum.CONSUMER_NAME, ShotOrderFieldEnum.ADDRESS, ShotOrderFieldEnum.SKU_NO,
                        ShotOrderFieldEnum.ITEM_ID, ShotOrderFieldEnum.REPEAT_ORDER_PHONE, ShotOrderFieldEnum.REPEAT_ORDER_TUIAID, ShotOrderFieldEnum.ADRESS_LENGTH,
                        ShotOrderFieldEnum.REPEAT_ORDER_IP, ShotOrderFieldEnum.PHONE_STATUS, ShotOrderFieldEnum.INVALID_ADDRESS, ShotOrderFieldEnum.REPEAT_ORDER_PHONE_ITEM,
                        ShotOrderFieldEnum.REPEAT_ORDER_PHONE_MERCHANT, ShotOrderFieldEnum.IP_MOBILE_ADDRESS_CHECK, ShotOrderFieldEnum.REPEAT_ORDER_TUIACID, ShotOrderFieldEnum.MOBILE_DUPLICATE_HIT);
                break;

                default:
                    break;
        }

        return fieldList;
    }

}
