package com.qiho.center.api.enums.area.code;

import com.qiho.center.api.enums.area.AreaCodeEnumerable;

import java.util.Arrays;

public enum AreaCodeCQEnum implements AreaCodeEnumerable {
    CODE_500000("500000", "重庆市"),
    CODE_500100("500100", "重庆市市辖区"),
    CODE_500101("500101", "重庆市万州区"),
    CODE_500102("500102", "重庆市涪陵区"),
    CODE_500103("500103", "重庆市渝中区"),
    CODE_500104("500104", "重庆市大渡口区"),
    CODE_500105("500105", "重庆市江北区"),
    CODE_500106("500106", "重庆市沙坪坝区"),
    CODE_500107("500107", "重庆市九龙坡区"),
    CODE_500108("500108", "重庆市南岸区"),
    CODE_500109("500109", "重庆市北碚区"),
    CODE_500110("500110", "重庆市万盛区"),
    CODE_500111("500111", "重庆市双桥区"),
    CODE_500112("500112", "重庆市渝北区"),
    CODE_500113("500113", "重庆市巴南区"),
    CODE_500200("500200", "重庆市县"),
    CODE_500221("500221", "重庆市长寿县"),
    CODE_500222("500222", "重庆市綦江县"),
    CODE_500223("500223", "重庆市潼南县"),
    CODE_500224("500224", "重庆市铜梁县"),
    CODE_500225("500225", "重庆市大足县"),
    CODE_500226("500226", "重庆市荣昌县"),
    CODE_500227("500227", "重庆市璧山县"),
    CODE_500228("500228", "重庆市梁平县"),
    CODE_500229("500229", "重庆市城口县"),
    CODE_500230("500230", "重庆市丰都县"),
    CODE_500231("500231", "重庆市垫江县"),
    CODE_500232("500232", "重庆市武隆县"),
    CODE_500233("500233", "重庆市忠县"),
    CODE_500234("500234", "重庆市开县"),
    CODE_500235("500235", "重庆市云阳县"),
    CODE_500236("500236", "重庆市奉节县"),
    CODE_500237("500237", "重庆市巫山县"),
    CODE_500238("500238", "重庆市巫溪县"),
    CODE_500239("500239", "重庆市黔江土家族苗族自治县"),
    CODE_500240("500240", "重庆市石柱土家族自治县"),
    CODE_500241("500241", "重庆市秀山土家族苗族自治县"),
    CODE_500242("500242", "重庆市酉阳土家族苗族自治县"),
    CODE_500243("500243", "重庆市彭水苗族土家族自治县"),
    CODE_500300("500300", "重庆市(市)"),
    CODE_500381("500381", "重庆市江津市"),
    CODE_500382("500382", "重庆市合川市"),
    CODE_500383("500383", "重庆市永川市"),
    CODE_500384("500384", "重庆市南川市"),
    ;
    /** 代码 */
    private String code;

    /** 描述 */
    private String desc;

    AreaCodeCQEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public boolean isExist(String code) {
        return Arrays.stream(values()).filter(v -> v.code.equals(code)).findFirst().isPresent();
    }
}
