package com.qiho.center.api.enums.area.code;

import com.qiho.center.api.enums.area.AreaCodeEnumerable;

import java.util.Arrays;

public enum AreaCodeGUZEnum implements AreaCodeEnumerable {
    CODE_520000("520000", "贵州省"),
    CODE_520100("520100", "贵州省贵阳市"),
    CODE_520101("520101", "贵州省贵阳市市辖区"),
    CODE_520102("520102", "贵州省贵阳市南明区"),
    CODE_520103("520103", "贵州省贵阳市云岩区"),
    CODE_520111("520111", "贵州省贵阳市花溪区"),
    CODE_520112("520112", "贵州省贵阳市乌当区"),
    CODE_520113("520113", "贵州省贵阳市白云区"),
    CODE_520121("520121", "贵州省贵阳市开阳县"),
    CODE_520122("520122", "贵州省贵阳市息烽县"),
    CODE_520123("520123", "贵州省贵阳市修文县"),
    CODE_520181("520181", "贵州省贵阳市清镇市"),
    CODE_520200("520200", "贵州省六盘水市"),
    CODE_520201("520201", "贵州省六盘水市钟山区"),
    CODE_520202("520202", "贵州省六盘水市盘县特区"),
    CODE_520203("520203", "贵州省六盘水市六枝特区"),
    CODE_520221("520221", "贵州省六盘水市水城县"),
    CODE_520300("520300", "贵州省遵义市"),
    CODE_520301("520301", "贵州省遵义市市辖区"),
    CODE_520302("520302", "贵州省遵义市红花岗区"),
    CODE_520321("520321", "贵州省遵义市遵义县"),
    CODE_520322("520322", "贵州省遵义市桐梓县"),
    CODE_520323("520323", "贵州省遵义市绥阳县"),
    CODE_520324("520324", "贵州省遵义市正安县"),
    CODE_520325("520325", "贵州省遵义市道真仡佬族苗族自治县"),
    CODE_520326("520326", "贵州省遵义市务川仡佬族苗族自治县"),
    CODE_520327("520327", "贵州省遵义市凤冈县"),
    CODE_520328("520328", "贵州省遵义市湄潭县"),
    CODE_520329("520329", "贵州省遵义市余庆县"),
    CODE_520330("520330", "贵州省遵义市习水县"),
    CODE_520381("520381", "贵州省遵义市赤水市"),
    CODE_520382("520382", "贵州省遵义市仁怀市"),
    CODE_522200("522200", "贵州省铜仁地区"),
    CODE_522201("522201", "贵州省铜仁地区铜仁市"),
    CODE_522222("522222", "贵州省铜仁地区江口县"),
    CODE_522223("522223", "贵州省铜仁地区玉屏侗族自治县"),
    CODE_522224("522224", "贵州省铜仁地区石阡县"),
    CODE_522225("522225", "贵州省铜仁地区思南县"),
    CODE_522226("522226", "贵州省铜仁地区印江土家族苗族自治县"),
    CODE_522227("522227", "贵州省铜仁地区德江县"),
    CODE_522228("522228", "贵州省铜仁地区沿河土家族自治县"),
    CODE_522229("522229", "贵州省铜仁地区松桃苗族自治县"),
    CODE_522230("522230", "贵州省铜仁地区万山特区"),
    CODE_522300("522300", "贵州省黔西南布依族苗族自治州"),
    CODE_522301("522301", "贵州省黔西南布依族苗族自治州兴义市"),
    CODE_522322("522322", "贵州省黔西南布依族苗族自治州兴仁县"),
    CODE_522323("522323", "贵州省黔西南布依族苗族自治州普安县"),
    CODE_522324("522324", "贵州省黔西南布依族苗族自治州晴隆县"),
    CODE_522325("522325", "贵州省黔西南布依族苗族自治州贞丰县"),
    CODE_522326("522326", "贵州省黔西南布依族苗族自治州望谟县"),
    CODE_522327("522327", "贵州省黔西南布依族苗族自治州册亨县"),
    CODE_522328("522328", "贵州省黔西南布依族苗族自治州安龙县"),
    CODE_522400("522400", "贵州省毕节地区"),
    CODE_522401("522401", "贵州省毕节地区毕节市"),
    CODE_522422("522422", "贵州省毕节地区大方县"),
    CODE_522423("522423", "贵州省毕节地区黔西县"),
    CODE_522424("522424", "贵州省毕节地区金沙县"),
    CODE_522425("522425", "贵州省毕节地区织金县"),
    CODE_522426("522426", "贵州省毕节地区纳雍县"),
    CODE_522427("522427", "贵州省毕节地区威宁彝族回族苗族自治县"),
    CODE_522428("522428", "贵州省毕节地区赫章县"),
    CODE_522500("522500", "贵州省安顺地区"),
    CODE_522501("522501", "贵州省安顺地区安顺市"),
    CODE_522526("522526", "贵州省安顺地区平坝县"),
    CODE_522527("522527", "贵州省安顺地区普定县"),
    CODE_522528("522528", "贵州省安顺地区关岭布依族苗族自治县"),
    CODE_522529("522529", "贵州省安顺地区镇宁布依族苗族自治县"),
    CODE_522530("522530", "贵州省安顺地区紫云苗族布依族自治县"),
    CODE_522600("522600", "贵州省黔东南苗族侗族自治州"),
    CODE_522601("522601", "贵州省黔东南苗族侗族自治州凯里市"),
    CODE_522622("522622", "贵州省黔东南苗族侗族自治州黄平县"),
    CODE_522623("522623", "贵州省黔东南苗族侗族自治州施秉县"),
    CODE_522624("522624", "贵州省黔东南苗族侗族自治州三穗县"),
    CODE_522625("522625", "贵州省黔东南苗族侗族自治州镇远县"),
    CODE_522626("522626", "贵州省黔东南苗族侗族自治州岑巩县"),
    CODE_522627("522627", "贵州省黔东南苗族侗族自治州天柱县"),
    CODE_522628("522628", "贵州省黔东南苗族侗族自治州锦屏县"),
    CODE_522629("522629", "贵州省黔东南苗族侗族自治州剑河县"),
    CODE_522630("522630", "贵州省黔东南苗族侗族自治州台江县"),
    CODE_522631("522631", "贵州省黔东南苗族侗族自治州黎平县"),
    CODE_522632("522632", "贵州省黔东南苗族侗族自治州榕江县"),
    CODE_522633("522633", "贵州省黔东南苗族侗族自治州从江县"),
    CODE_522634("522634", "贵州省黔东南苗族侗族自治州雷山县"),
    CODE_522635("522635", "贵州省黔东南苗族侗族自治州麻江县"),
    CODE_522636("522636", "贵州省黔东南苗族侗族自治州丹寨县"),
    CODE_522700("522700", "贵州省黔南布依族苗族自治州"),
    CODE_522701("522701", "贵州省黔南布依族苗族自治州都匀市"),
    CODE_522702("522702", "贵州省黔南布依族苗族自治州福泉市"),
    CODE_522722("522722", "贵州省黔南布依族苗族自治州荔波县"),
    CODE_522723("522723", "贵州省黔南布依族苗族自治州贵定县"),
    CODE_522725("522725", "贵州省黔南布依族苗族自治州瓮安县"),
    CODE_522726("522726", "贵州省黔南布依族苗族自治州独山县"),
    CODE_522727("522727", "贵州省黔南布依族苗族自治州平塘县"),
    CODE_522728("522728", "贵州省黔南布依族苗族自治州罗甸县"),
    CODE_522729("522729", "贵州省黔南布依族苗族自治州长顺县"),
    CODE_522730("522730", "贵州省黔南布依族苗族自治州龙里县"),
    CODE_522731("522731", "贵州省黔南布依族苗族自治州惠水县"),
    CODE_522732("522732", "贵州省黔南布依族苗族自治州三都水族自治县"),
    ;
    /** 代码 */
    private String code;

    /** 描述 */
    private String desc;

    AreaCodeGUZEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }
    @Override
    public boolean isExist(String code) {
        return Arrays.stream(values()).filter(v -> v.code.equals(code)).findFirst().isPresent();
    }
}
